<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo e(config('app.name', 'Laravel')); ?></title>

        <!-- Fonts -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap">

        <script src="<?php echo e(asset('js/app.js')); ?>" defer></script>
        <!-- Styles -->
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.2/css/all.min.css" />
        <link href="https://unpkg.com/filepond/dist/filepond.css" rel="stylesheet" />
        <link rel="stylesheet" href="<?php echo e(mix('css/app.css')); ?>">
        <!-- All Plugins Css -- from boostrap to animate css -- -->
        <link href="<?php echo e(asset('assets/css/plugins.css')); ?>" rel="stylesheet" />
        <!-- Custom CSS -->
        <link href="<?php echo e(asset('assets/css/styles.css')); ?>" rel="stylesheet" />
        <link href="<?php echo e(asset('assets/css/custom.css')); ?>" rel="stylesheet" />

        <!-- Scripts -->
        <script src="<?php echo e(mix('js/app.js')); ?>" defer></script>
        <script src="https://cdn.jsdelivr.net/gh/alpinejs/alpine@v2.8.2/dist/alpine.min.js" ></script>
        <style>
            .topbar {
                width: 100%;
                height: 50px;
                display: flex;
                flex-wrap: wrap;
                position: absolute;
                left: 0;
                top: 0;
                bottom: 3px;
                z-index: 1;
            }
        </style>
        <?php echo \Livewire\Livewire::styles(); ?>


    </head>
    <body class="blue-skin">
        <div class="topbar">
            <div class="container">
                

            </div><!-- end container -->
        </div>
        <div id="main-wrapper">
            <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('inc.nav-menu')->html();
} elseif ($_instance->childHasBeenRendered('2S60ynf')) {
    $componentId = $_instance->getRenderedChildComponentId('2S60ynf');
    $componentTag = $_instance->getRenderedChildComponentTagName('2S60ynf');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('2S60ynf');
} else {
    $response = \Livewire\Livewire::mount('inc.nav-menu');
    $html = $response->html();
    $_instance->logRenderedChild('2S60ynf', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <!-- Page Content -->
                <main style="margin-top: 5rem;">
                    <?php echo e($slot); ?>

                </main>
            <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('inc.footer')->html();
} elseif ($_instance->childHasBeenRendered('CZmE03v')) {
    $componentId = $_instance->getRenderedChildComponentId('CZmE03v');
    $componentTag = $_instance->getRenderedChildComponentTagName('CZmE03v');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('CZmE03v');
} else {
    $response = \Livewire\Livewire::mount('inc.footer');
    $html = $response->html();
    $_instance->logRenderedChild('CZmE03v', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
            <?php echo $__env->yieldPushContent('modals'); ?>
        </div>
        <?php echo \Livewire\Livewire::scripts(); ?>




        <script src="<?php echo e(asset('js/app.js')); ?>" ></script>
        <script src="<?php echo e(asset('assets/js/jquery.min.js')); ?>" ></script>
        <script src="<?php echo e(asset('assets/js/popper.min.js')); ?>" defer></script>
        <script src="<?php echo e(asset('assets/js/bootstrap.min.js')); ?>" defer></script>
        <script src="<?php echo e(asset('assets/js/select2.min.js')); ?>" defer></script>
        <script src="<?php echo e(asset('assets/js/owl.carousel.min.js')); ?>" defer></script>
        <script src="<?php echo e(asset('assets/js/ion.rangeSlider.min.js')); ?>" defer></script>
        <script src="<?php echo e(asset('assets/js/counterup.min.js')); ?>" defer></script>
        <script src="<?php echo e(asset('assets/js/materialize.min.js')); ?>" defer></script>
        <script src="<?php echo e(asset('assets/js/metisMenu.min.js')); ?>" defer></script>
        <script src="<?php echo e(asset('assets/js/custom.js')); ?>" defer></script>
        <script src="https://unpkg.com/filepond/dist/filepond.js" ></script>
        <script>

            $(document).ready(function(){
                console.log('Ready');
            });
        </script>
        <script type="text/javascript">
          function showAuthPass (element) {
               var x = document.getElementById('auth_pass');
               if (x.type === "password") {
                   element.innerHTML= 'Hide';
                   x.type = "text";
               } else {
                   element.innerHTML= 'Show';
                   x.type = "password";
               }
           }
         function showPass (element) {
               var x = document.getElementById("password");
               if (x.type === "password") {
                   element.innerHTML= 'Hide';
                   x.type = "text";
               } else {
                   element.innerHTML= 'Show';
                   x.type = "password";
               }
           }
        function showConfirmPass(element) {
               var x = document.getElementById("confirm_password");
               if (x.type === "password") {
                   element.innerHTML= 'Hide';
                   x.type = "text";
               } else {
                   element.innerHTML= 'Show';
                   x.type = "password";
               }
           }
        </script>
        <?php echo $__env->yieldContent('scripts'); ?>
    </body>
</html>
<?php /**PATH C:\xampp\htdocs\Nariphon_Technologies\typewriter\resources\views/layouts/app.blade.php ENDPATH**/ ?>