<div>
    
    <div x-data="{ dropdownOpen: false }">
       <a @click="dropdownOpen = !dropdownOpen" class="px-4 py-2 mt-2 text-lg text-gray-900 bg-gray-200 rounded-lg sm:mt-0 hover:text-gray-900 focus:text-gray-900 hover:bg-gray-300"
            href="#">
            <span
                class="badge mb-3 bg-red-800 rounded-full px-2 py-1 text-center object-right-top text-white text-sm mr-1"><?php echo e($counts); ?></span>
            <i class="bi bi-bell-fill fs-3"></i>
        </a>

        <div x-cloak x-show="dropdownOpen" @click="dropdownOpen = false" class="fixed inset-0 h-full w-full z-10"></div>

        <div x-cloak x-show="dropdownOpen" class="absolute right-0 mt-2 bg-white rounded-md shadow-lg overflow-hidden z-20"
            style="width:25rem;">
            <div class="py-2">
                <?php if(session()->get('LoggedClient') != null): ?>
                    <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($item->title == "Sent Invoice"): ?>
                    <a href="#" class="flex items-center px-4 py-3 border-b hover:bg-gray-100 -mx-2">

                        <p class="text-gray-600 text-sm mx-2">
                            <span class="font-bold" href="#">Confirm Invoice of <span class="font-bold text-blue-500"
                                >$<?php echo e($item->value); ?></span> </span> created on
                                <span x-on:click="$wire.gotToOrder('<?php echo e($item->order_no); ?>')" class="font-bold text-blue-500"
                                    href="#"><?php echo e($item->order_no); ?></span> . 2m
                        </p>
                    </a>
                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php elseif(auth()->user() != null): ?>
                    <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($item->title == "Sent Invoice"): ?>
                    <a href="#" class="flex items-center px-4 py-3 border-b hover:bg-gray-100 -mx-2">

                        <p x-on:click="$wire.gotToOrder('<?php echo e($item->order_no); ?>', '<?php echo e($item->id); ?>')" class="text-gray-600 text-sm mx-2">
                            <span class="font-bold" href="#">Invoice of <span class="font-bold text-blue-500"
                                >$<?php echo e($item->value); ?></span> </span> was <?php echo e($item->status); ?>

                                <span x-on:click="$wire.gotToOrder('<?php echo e($item->order_no); ?>', '<?php echo e($item->id); ?>')" class="font-bold text-blue-500"
                                    href="#"><?php echo e($item->order_no); ?></span> . <?php echo e($item->created_at->diffForHumans()); ?>

                        </p>
                    </a>
                    <?php elseif($item->title == "Access Client"): ?>
                    <a href="#" class="flex items-center px-4 py-3 border-b hover:bg-gray-100 -mx-2">

                        <p  class="text-gray-600 text-sm mx-2">
                            <span class="font-bold" href="#">Writer
                            <span class="font-bold text-blue-500"><?php echo e($this->getWriter( $item->fromable_id )); ?></span>
                            with  <span class="font-bold text-blue-500"> <?php echo e($item->order_no); ?></span> asking permission to chat with the client
                            <span  x-data="{}" x-on:click="$dispatch('dlg-modal');$wire.giveAccess('<?php echo e($item->fromable_id); ?>', <?php echo e($item->id); ?>)"
                            class="font-extrabold text-blue-500 hover:underline" href="#">Give Access</span> . <?php echo e($item->created_at->diffForHumans()); ?>

                        </p>
                        <div x-data="{isDlgModal:false}" :class="{ 'block': isDlgModal, 'hidden': !isDlgModal }"
                                    class="hidden" x-on:dlg-modal.window="isDlgModal = !isDlgModal"
                                    @click.away="isDlgModal = false">

                            <?php echo $__env->make('livewire.general.global-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </a>
                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php $__currentLoopData = $generalNotifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($item->title == 'Bid Created'): ?>
                        <a href="#" class="flex items-center px-4 py-3 border-b hover:bg-gray-100 -mx-2">
                            <p  class="text-gray-600 text-sm mx-2">
                                <span class="font-bold" href="#">You have new bid for
                                <span class="font-bold text-blue-500"> <?php echo e($item->description); ?></span>
                                <span  x-on:click="$wire.markAsReadGeneral('<?php echo e($item->id); ?>')"
                                class="font-extrabold text-blue-500 hover:underline" href="#">Mark As Read</span> . <?php echo e($item->created_at->diffForHumans()); ?>

                            </p>
                        </a>
                        <?php endif; ?>
                        <?php if($item->title == 'Order Created'): ?>
                        <a href="#" class="flex items-center px-4 py-3 border-b hover:bg-gray-100 -mx-2">
                            <p  class="text-gray-600 text-sm mx-2">
                                <span class="font-bold" href="#">You have new
                                <span class="font-bold text-blue-500"> <?php echo e($item->description); ?></span>
                                <span  x-on:click="$wire.goToNewOrder('<?php echo e($item->description); ?>', '<?php echo e($item->id); ?>')"
                                class="font-extrabold text-blue-500 hover:underline" href="#">Go To Order</span> . <?php echo e($item->created_at->diffForHumans()); ?>

                            </p>
                        </a>
                        <?php endif; ?>
                        <?php if($item->title == 'Invoice Confirmed'): ?>
                        <a href="#" class="flex items-center px-4 py-3 border-b hover:bg-gray-100 -mx-2">
                            <p  class="text-gray-600 text-sm mx-2">
                                <span class="font-bold" href="#">Invoice for
                                <span class="font-bold text-blue-500"> <?php echo e($item->description); ?> </span>
                                <span class="font-bold"> was </span>
                                <span class="font-bold text-green-500 mr-1"> accepted </span>
                                <span  x-on:click="$wire.markAsReadGeneral('<?php echo e($item->id); ?>')"
                                class="font-extrabold text-blue-500 hover:underline" href="#">Mark As Read</span> . <?php echo e($item->created_at->diffForHumans()); ?>

                            </p>
                        </a>
                        <?php endif; ?>
                        <?php if($item->title == 'Invoice Rejected'): ?>
                        <a href="#" class="flex items-center px-4 py-3 border-b hover:bg-gray-100 -mx-2">
                            <p  class="text-gray-600 text-sm mx-2">
                                <span class="font-bold" href="#">Invoice for
                                <span class="font-bold text-blue-500"> <?php echo e($item->description); ?> </span>
                                <span class="font-bold"> was </span>
                                <span class="font-bold text-red-500 mr-1"> rejected </span>
                                <span  x-on:click="$wire.markAsReadGeneral('<?php echo e($item->id); ?>')"
                                class="font-extrabold text-blue-500 hover:underline" href="#">Mark As Read</span> . <?php echo e($item->created_at->diffForHumans()); ?>

                            </p>
                        </a>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <?php elseif(session()->get('AuthWriter') != null): ?>
                    <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($item->title == "Access Granted"): ?>
                        <a href="#" class="flex items-center px-4 py-3 border-b hover:bg-gray-100 -mx-2">
                            <p  class="text-gray-600 text-sm mx-2">
                                <span class="font-bold" href="#">Access Granted. You can now chat with client of
                                <span class="font-bold text-blue-500"> <?php echo e($item->order_no); ?></span>
                                <span  x-on:click="$wire.markAsRead('<?php echo e($item->id); ?>')"
                                class="font-extrabold text-blue-500 hover:underline" href="#">Mark As Read</span> . <?php echo e($item->created_at->diffForHumans()); ?>

                            </p>
                        </a>
                        <?php elseif($item->title == "Access Denied"): ?>
                        <a href="#" class="flex items-center px-4 py-3 border-b hover:bg-gray-100 -mx-2">
                            <p  class="text-gray-600 text-sm mx-2">
                                <span class="font-bold" href="#">Your request to chat with client of
                                <span class="font-bold text-blue-500"> <?php echo e($item->order_no); ?></span> has been denied.
                                <span  x-on:click="$wire.markAsRead('<?php echo e($item->id); ?>')"
                                class="font-extrabold text-blue-500 hover:underline" href="#">Mark As Read</span> . <?php echo e($item->created_at->diffForHumans()); ?>

                            </p>
                        </a>
                        <?php elseif($item->title == "Order Award"): ?>
                        <a href="#" class="flex items-center px-4 py-3 border-b hover:bg-gray-100 -mx-2">
                            <p  class="text-gray-600 text-sm mx-2">
                                <span class="font-bold" href="#">Your have been awarded
                                <span class="font-bold text-blue-500"> <?php echo e($item->order_no); ?></span> with a bid of<span class="font-bold text-blue-500"> <?php echo e($item->value); ?> per page</span>.
                                <span  x-on:click="$wire.markAsRead('<?php echo e($item->id); ?>')"
                                class="font-extrabold text-blue-500 hover:underline" href="#">Mark As Read</span> . <?php echo e($item->created_at->diffForHumans()); ?>

                            </p>
                        </a>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
            <a href="#" class="block bg-gray-800 text-white text-center font-bold py-2">See all notifications</a>
        </div>
    </div>
</div>
<style>
    [x-cloak] { display: none !important; }
</style>
<script>
    window.addEventListener('open-order-from-notification', event => {
        // window.livewire.emit('open-order-from-notification', event.detail.order_no);
        // window.livewire.emit('open_eye');
        // alert('Order No: ' + event.detail.order_no);
    })
</script>
<?php /**PATH C:\xampp\htdocs\Nariphon_Technologies\typewriter\resources\views/livewire/admin/inc/notification.blade.php ENDPATH**/ ?>