<div>
<div wire:loading wire:target='pendingOrders, progress, completed, revisions'>
    <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('general.loader')->html();
} elseif ($_instance->childHasBeenRendered('lrn975V')) {
    $componentId = $_instance->getRenderedChildComponentId('lrn975V');
    $componentTag = $_instance->getRenderedChildComponentTagName('lrn975V');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('lrn975V');
} else {
    $response = \Livewire\Livewire::mount('general.loader');
    $html = $response->html();
    $_instance->logRenderedChild('lrn975V', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
</div>

<nav wire:ignore
    x-data="{ selected: <?php if ((object) ('selectedItem') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($_instance->id); ?>').entangle('<?php echo e('selectedItem'->value()); ?>')<?php echo e('selectedItem'->hasModifier('defer') ? '.defer' : ''); ?> <?php else : ?> window.Livewire.find('<?php echo e($_instance->id); ?>').entangle('<?php echo e('selectedItem'); ?>') <?php endif; ?> }"
    class="side-nav">
    <a href="" class="intro-x flex items-center pl-5 pt-4">
        <img alt="Logo" src="<?php echo e(asset('dash-assets/img/logo_full.svg')); ?>" class="w-6 max-h-50px logo-default" />
        <img alt="Logo" src="<?php echo e(asset('dash-assets/img/logo_short.svg')); ?>" class="w-6 max-h-50px logo-minimize" />
        <span class="hidden xl:block text-white text-lg ml-3"> <span class="font-medium"><?php echo e(config('app.name')); ?></span> </span>
    </a>
    <div class="side-nav__devider my-6"></div>
    <ul>
        <li>
            <a href="<?php echo e(route('dashboard')); ?>"
                x-bind:class="{ 'side-menu--active': selected === 'dashboard' }"
                @click="selected = 'dashboard'"
                class="side-menu">
                <div class="side-menu__icon"> <i data-feather="home"></i> </div>
                <div class="side-menu__title">
                    Dashboard
                    <div class="side-menu__sub-icon transform rotate-180"> <i data-feather="chevron-down"></i> </div>
                </div>
            </a>
        </li>
        <li>
            <a href="javascript:;"
                @click="selected = 'orders'"
                :class="{ 'side-menu--active': selected === 'orders' }"
                class="side-menu">
                <div class="side-menu__icon"> <i data-feather="edit"></i> </div>
                <div class="side-menu__title">
                    Orders
                    <div class="side-menu__sub-icon "> <i data-feather="chevron-down"></i> </div>
                </div>
            </a>
            <ul class="">
                <li>
                    <a wire:click='pendingOrders' href="#" class="side-menu md:no-underline md:hover:underline">
                        <div class="side-menu__icon"> <i data-feather="activity"></i> </div>
                        <div class="side-menu__title"> Pending Orders </div>
                    </a>
                </li>
                <li>
                    <a wire:click='progress' href="#" class="side-menu md:no-underline md:hover:underline">
                        <div class="side-menu__icon"> <i data-feather="activity"></i> </div>
                        <div class="side-menu__title"> Orders In Progress </div>
                    </a>
                </li>
                <li>
                    <a  wire:click='completed' href="#" class="side-menu md:no-underline md:hover:underline">
                        <div class="side-menu__icon"> <i data-feather="activity"></i> </div>
                        <div class="side-menu__title"> Completed Orders </div>
                    </a>
                </li>
                <li>
                    <a  wire:click='revisions' href="#" class="side-menu md:no-underline md:hover:underline">
                        <div class="side-menu__icon"> <i data-feather="activity"></i> </div>
                        <div class="side-menu__title"> Revisions </div>
                    </a>
                </li>
            </ul>
        </li>
        <li>
            <a href="<?php echo e(route('client-invoice')); ?>"
                @click="selected = 'invoice'"
                :class="{ 'side-menu--active': selected === 'invoice' }"
                class="side-menu">
                <div class="side-menu__icon"> <i data-feather="inbox"></i> </div>
                <div class="side-menu__title"> Invoices </div>
            </a>
        </li>
        <li>
            <a href="<?php echo e(route('client-chat')); ?>"
                @click="selected = 'chat'"
                :class="{ 'side-menu--active': selected === 'chat' }"
                class="side-menu">
                <div class="side-menu__icon"> <i data-feather="message-square"></i> </div>
                <div class="side-menu__title"> Chat </div>
            </a>
        </li>
        <li class="side-nav__devider my-6"></li>

    </ul>
</nav>
</div>

<?php /**PATH C:\xampp\htdocs\Nariphon_Technologies\typewriter\resources\views/livewire/dashboard/inc/side-menu.blade.php ENDPATH**/ ?>