<div>
    
    <!--begin::Content-->
    <div wire:loading>
        <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('general.loader')->html();
} elseif ($_instance->childHasBeenRendered('M2NxG5q')) {
    $componentId = $_instance->getRenderedChildComponentId('M2NxG5q');
    $componentTag = $_instance->getRenderedChildComponentTagName('M2NxG5q');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('M2NxG5q');
} else {
    $response = \Livewire\Livewire::mount('general.loader');
    $html = $response->html();
    $_instance->logRenderedChild('M2NxG5q', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
    </div>
    <?php if($varView==''): ?>
    <div class="content fs-6 d-flex flex-column flex-column-fluid" id="kt_content">
        <!--begin::Toolbar-->
        <div class="toolbar" id="kt_toolbar">
            <div class="container-fluid d-flex flex-stack flex-wrap flex-sm-nowrap">
                <!--begin::Info-->
                <div class="d-flex flex-column align-items-start justify-content-center flex-wrap me-2">
                    <!--begin::Title-->
                    <h1 class="text-dark fw-bolder my-1 fs-2">
                        Dashboard
                        <small class="text-muted fs-6 fw-normal ms-1"></small>
                    </h1>
                    
                    <!--end::Title-->
                </div>
            </div>
        </div>
        <!--end::Toolbar-->
        <!-- Alert Info -->
        
        <!-- End Alert Info -->
        <!--How it Works-->
        <div class="w-full py-6">
            <div class="flex">
              <div class="w-1/4">
                <div class="relative mb-2">
                  <div class="w-10 h-10 mx-auto bg-green-500 rounded-full text-lg text-white flex items-center">
                    <span class="text-center text-white w-full">
                      1
                    </span>
                  </div>
                </div>

                <div class="text-md text-center md:text-base">Newly Created Orders Are Under Pending Orders</div>
              </div>

              <div class="w-1/4">
                <div class="relative mb-2">
                  <div class="absolute flex align-center items-center align-middle content-center" style="width: calc(100% - 2.5rem - 1rem); top: 50%; transform: translate(-50%, -50%)">
                    <div class="w-full bg-gray-200 rounded items-center align-middle align-center flex-1">
                      <div class="w-0 bg-green-300 py-1 rounded" style="width: 100%;"></div>
                    </div>
                  </div>

                  <div class="w-10 h-10 mx-auto bg-green-500 rounded-full text-lg text-white flex items-center">
                    <span class="text-center text-white w-full">
                      2
                    </span>
                  </div>
                </div>

                <div class="text-md text-center md:text-base">Confirm Order By Clicking <strong>"View"</strong> Button</div>
              </div>

              <div class="w-1/4">
                <div class="relative mb-2">
                  <div class="absolute flex align-center items-center align-middle content-center" style="width: calc(100% - 2.5rem - 1rem); top: 50%; transform: translate(-50%, -50%)">
                    <div class="w-full bg-gray-200 rounded items-center align-middle align-center flex-1">
                      <div class="w-0 bg-green-300 py-1 rounded" style="width: 100%;"></div>
                    </div>
                  </div>

                  <div class="w-10 h-10 mx-auto bg-green-500 rounded-full text-lg text-white flex items-center">
                    <span class="text-center text-white w-full">
                      3
                    </span>
                  </div>
                </div>

                <div class="text-md text-center md:text-base">Negotiate Price Under Chat Section</div>
              </div>

              <div class="w-1/4">
                <div class="relative mb-2">
                  <div class="absolute flex align-center items-center align-middle content-center" style="width: calc(100% - 2.5rem - 1rem); top: 50%; transform: translate(-50%, -50%)">
                    <div class="w-full bg-gray-200 rounded items-center align-middle align-center flex-1">
                      <div class="w-0 bg-green-300 py-1 rounded" style="width: 100%;"></div>
                    </div>
                  </div>

                  <div class="w-10 h-10 mx-auto bg-green-500 rounded-full text-lg text-white flex items-center">
                    <span class="text-center text-white w-full">
                      4
                    </span>
                  </div>
                </div>

                <div class="text-md text-center md:text-base">Send Invoice For Client To Confirm</div>
              </div>
            </div>
        </div>
        <!--End How it Works-->
        <!--begin::Post-->
        <div class="post fs-6 d-flex flex-column-fluid" id="kt_post">
            <!--begin::Container-->
            <div class="container">
                <!--begin::Row-->
                <?php if($centerView != ''): ?>
                <button wire:click='default'
                    class=" btn-primary transition duration-150 ease-in-out transform hover:scale-110 bg-emerald-600 text-white font-semibold py-3 px-6 rounded-md">
                    <span class="text-white svg-icon svg-icon-2 rotate-180">
                        <i class="bi bi-arrow-bar-left"></i>
                    </span>
                    Back
                </button>
                <?php endif; ?>

                <br>
                <div class="row g-xl-8">

                    <?php if($menuButtons): ?>
                         <!-- Earnings (Monthly) Card Example -->
                        <div wire:click='pending' class="col-xl-3 col-md-6 mb-4 cursor-pointer">
                            <div class=" border-l-2 border-gray-600 shadow h-70 py-2 transition duration-150 ease-in-out transform hover:scale-110 bg-emerald-600 text-white font-semibold py-3 px-6 rounded-md" >
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-md font-weight-bold text-primary text-uppercase mb-1">
                                               Pending Orders</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                <?php $counter=0; ?>
                                                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($order->status == 'Pending'): ?>
                                                <?php $counter++; ?>
                                                <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php echo e($counter); ?>

                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-pause-circle fa-2x text-info"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div wire:click='cancelled' class="col-xl-3 col-md-6 mb-4 cursor-pointer">
                            <div class=" border-l-2 border-success shadow h-70 py-2 transition duration-150 ease-in-out transform hover:scale-110 bg-emerald-600 text-white font-semibold py-3 px-6 rounded-md">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-md font-weight-bold text-primary text-uppercase mb-1">
                                                Cancled Orders</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">0</div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-ban fa-2x text-danger"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div wire:click='progress' class="col-xl-3 col-md-6 mb-4 cursor-pointer">
                            <div class=" border-l-2 border-success shadow h-70 py-2 transition duration-150 ease-in-out transform hover:scale-110 bg-emerald-600 text-white font-semibold py-3 px-6 rounded-md">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-md font-weight-bold text-primary text-uppercase mb-1">
                                                Orders In Progress</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                <?php $counter=0; ?>
                                                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($order->status == 'In progress'): ?>
                                                <?php $counter++; ?>
                                                <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php echo e($counter); ?>

                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-tasks fa-2x text-primary"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div wire:click='completed' class="col-xl-3 col-md-6 mb-4 cursor-pointer">
                            <div class=" border-l-2 border-success shadow h-70 py-2 transition duration-150 ease-in-out transform hover:scale-110 bg-emerald-600 text-white font-semibold py-3 px-6 rounded-md">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-md font-weight-bold text-primary text-uppercase mb-1">
                                              Completed Orders</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                <?php $counter=0; ?>
                                                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($order->status == 'Complete'): ?>
                                                <?php $counter++; ?>
                                                <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php echo e($counter); ?>

                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-check fa-2x text-primary"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div wire:click='revisions' class="col-xl-3 col-md-6 mb-4 cursor-pointer">
                            <div class=" border-l-2 border-success shadow h-70 py-2 transition duration-150 ease-in-out transform hover:scale-110 bg-emerald-600 text-white font-semibold py-3 px-6 rounded-md">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-md font-weight-bold text-primary text-uppercase mb-1">
                                             Revisions</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                <?php $counter=0; ?>
                                                <?php $__currentLoopData = $revisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $revision): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($revision->status == 'Pending'): ?>
                                                <?php $counter++; ?>
                                                <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php echo e($counter); ?>

                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-redo fa-2x text-danger"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div wire:click='doneRevisions' class="col-xl-3 col-md-6 mb-4 cursor-pointer">
                            <div class=" border-l-2 border-success shadow h-70 py-2 transition duration-150 ease-in-out transform hover:scale-110 bg-emerald-600 text-white font-semibold py-3 px-6 rounded-md">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-md font-weight-bold text-primary text-uppercase mb-1">
                                            Revised Orders</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                <?php $counter=0; ?>
                                                <?php $__currentLoopData = $revisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $revision): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($revision->status == 'Done'): ?>
                                                <?php $counter++; ?>
                                                <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php echo e($counter); ?>

                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-check-double fa-2x text-primary"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>



                        <?php if($centerView == ''): ?>
                             <!--begin::Col-->
                        <div class="col-xxl-8">
                            <!--begin::Row-->
                            <div class="row g-xl-8">
                                <!--begin::Col-->
                                <div class="col-xl-6">
                                    <!--begin::Chart Widget 1-->
                                    <div class="card card-xl-stretch mb-5 mb-xl-8">
                                        <!--begin::Body-->
                                        <div class="card-body p-0 d-flex justify-content-between flex-column">
                                            <div class="d-flex flex-stack card-p flex-grow-1">
                                                <!--begin::Icon-->
                                                <div class="symbol symbol-45px">
                                                    <div class="symbol-label">
                                                        <!--begin::Svg Icon | path: icons/stockholm/Shopping/Cart4.svg-->
                                                        <span class="svg-icon svg-icon-2x">
                                                            <i class="bi bi-basket2"></i>
                                                        </span>
                                                        <!--end::Svg Icon-->
                                                    </div>
                                                </div>
                                                <!--end::Icon-->
                                                <!--begin::Text-->
                                                <div class="d-flex flex-column text-end">
                                                    <span class="fw-boldest text-gray-800 fs-2">Essay Orders</span>
                                                    <span class="text-gray-900 fw-bold fs-6">April 1 - May 5</span>
                                                </div>
                                                <!--end::Text-->
                                            </div>
                                            <!--begin::Chart-->
                                            <div class="pt-1">
                                                <div id="kt_chart_widget_1_chart" class="card-rounded-bottom h-125px"></div>
                                            </div>
                                            <!--end::Chart-->
                                        </div>
                                    </div>
                                    <!--end::Chart Widget 1-->
                                </div>
                                <!--end::Col-->
                                <!--begin::Col-->
                                <div class="col-xl-6">
                                    <!--begin::Slider Widget 1-->
                                    <div class="card card-xl-stretch mb-5 mb-xl-8">
                                        <!--begin::Body-->
                                        <div class="card-body pt-5">
                                            <div id="kt_stats_widget_8_carousel"
                                                class="carousel carousel-custom carousel-stretch slide"
                                                data-bs-ride="carousel" data-bs-interval="8000">
                                                <!--begin::Heading-->
                                                <div class="d-flex flex-stack flex-wrap">
                                                    <span class="fs-4 text-gray-400 fw-boldest pe-2">Current Jobs</span>
                                                    <!--begin::Carousel Indicators-->
                                                    <ol class="p-0 m-0 carousel-indicators carousel-indicators-dots">
                                                        <?php $x=0; ?>
                                                        <?php $__currentLoopData = $progress_orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $progress_order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li data-bs-target="#kt_stats_widget_8_carousel"
                                                        data-bs-slide-to="<?php echo e($x); ?>" class="<?php echo e($x == 0? 'ms-1 active' : 'ms-1'); ?>"></li>
                                                        <?php $x++; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ol>
                                                    <!--end::Carousel Indicators-->
                                                </div>
                                                <!--end::Heading-->
                                                <!--begin::Carousel-->
                                                <div class="carousel-inner pt-6">
                                                    <!--begin::Item-->
                                                    <?php $x=0; ?>
                                                    <?php $__currentLoopData = $progress_orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $progress_order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class=" <?php echo e($x == 0? 'carousel-item active' : 'carousel-item'); ?>">
                                                        <div class="carousel-wrapper">
                                                            <div
                                                                class="d-flex flex-column justify-content-between flex-grow-1">
                                                                <a href="" class="fs-2 text-gray-800 text-hover-primary fw-boldest"><?php echo e($progress_order->order->username); ?></a>
                                                                <a href="" class="fs-2 text-gray-600 text-hover-primary fw-bold"><?php echo e($progress_order->category->subject); ?></a>
                                                                <p class="text-gray-600 fs-6 fw-bold pt-4 mb-0">
                                                                    <?php echo e(strlen($progress_order->instructions) > 50? substr($progress_order->instructions,0,50).'...':$progress_order->instructions); ?>


                                                                </p>
                                                            </div>
                                                            <!--begin::Info-->
                                                            <div class="d-flex flex-stack pt-8">
                                                                <?php
                                                                $startTime = \Carbon\Carbon::parse($progress_order->deadline_date);
                                                                // $startTime = $ongoing_order->deadline_date $ongoing_order->deadline_time ;
                                                                // {{ \Carbon\Carbon::now()->toDateString() }}
                                                                // $now = ;
                                                                $endTime = \Carbon\Carbon::now()->toDateString();

                                                                $totalDuration = $startTime->diff($endTime)->format('%H:%I:%S'). " Time left"
                                                                // $totalDuration = $endTime->diffForHumans($startTime);
                                                                // dd($totalDuration);
                                                                ?>
                                                                <?php if($totalDuration == 0): ?>
                                                                <span class="badge badge-light-danger fs-7 fw-boldest me-2"><?php echo e($totalDuration); ?></span>
                                                                <?php elseif($totalDuration > 1): ?>
                                                                <span class="badge badge-light-primary fs-7 fw-boldest me-2"><?php echo e($totalDuration); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                            <!--end::Info-->
                                                        </div>
                                                    </div>
                                                    <?php $x++; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </div>
                                                <!--end::Carousel-->
                                            </div>
                                        </div>
                                        <!--end::Body-->
                                    </div>
                                    <!--end::Slider Widget 1-->
                                </div>
                                <!--end::Col-->
                            </div>
                            <!--end::Row-->
                            <!--begin::Row-->
                            <div class="row g-xl-8">
                                <!--begin::Col-->
                                <div class="col-xl-6">
                                    <!--begin::Chart Widget 2-->
                                    <div class="card card-xl-stretch mb-5 mb-xl-8">
                                        <!--begin::Body-->
                                        <div
                                            class="card-body p-0 d-flex justify-content-between flex-column overflow-hidden">
                                            <div class="d-flex flex-stack flex-grow-1 px-9 pt-9 pb-3">
                                                <!--begin::Icon-->
                                                <div class="symbol symbol-45px">
                                                    <div class="symbol-label">
                                                        <!--begin::Svg Icon | path: icons/stockholm/Shopping/Cart5.svg-->
                                                        <span class="svg-icon svg-icon-2x">
                                                            <i class="bi bi-basket2"></i>
                                                        </span>
                                                        <!--end::Svg Icon-->
                                                    </div>
                                                </div>
                                                <!--end::Icon-->
                                                <!--begin::Text-->
                                                <div class="d-flex flex-column text-end">
                                                    <span class="fw-boldest text-gray-800 fs-2">Earnings</span>
                                                    <span class="text-gray-900 fw-bold fs-6">April 8 - May 5</span>
                                                </div>
                                                <!--end::Text-->
                                            </div>
                                            <!--begin::Chart-->
                                            <div id="kt_charts_widget_2_chart" style="height: 165px"></div>
                                            <!--end::Chart-->
                                        </div>
                                    </div>
                                    <!--end::Chart Widget 2-->
                                </div>
                                <!--end::Col-->
                                <!--begin::Col-->
                                <div class="col-xl-6">
                                    <!--begin::Slider widget 2-->
                                    <div class="card card-xl-stretch mb-5 mb-xl-8">
                                        <!--begin::Body-->
                                        <div class="card-body p-9">
                                            <!--begin::Heading-->
                                            <div class="fs-2hx fw-boldest"><?php echo e(count($orders)); ?></div>
                                            <div class="fs-4 fw-bold text-gray-400 mb-7">
                                                Commpany Projects
                                            </div>
                                            <!--end::Heading-->
                                            <!--begin::Wrapper-->
                                            <div class="d-flex flex-wrap">
                                                <!--begin::Chart-->
                                                <div class="d-flex flex-center h-100px w-100px me-9 mb-5">
                                                    <canvas id="kt_project_list_chart"></canvas>
                                                </div>
                                                <!--end::Chart-->
                                                <!--begin::Labels-->
                                                <div
                                                    class="d-flex flex-column justify-content-center flex-row-fluid pe-11 mb-5">
                                                    <!--begin::Label-->
                                                    <div class="d-flex fs-6 fw-bold align-items-center mb-3">
                                                        <div class="bullet bg-primary me-3"></div>
                                                        <div class="text-gray-900">Active</div>
                                                        <div class="ms-auto fw-boldest text-gray-700">
                                                            <?php $counter=0; ?>
                                                            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if($order->status == 'In progress'): ?>
                                                            <?php $counter++; ?>
                                                            <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php echo e($counter); ?>

                                                        </div>
                                                    </div>
                                                    <!--end::Label-->
                                                    <!--begin::Label-->
                                                    <div class="d-flex fs-6 fw-bold align-items-center mb-3">
                                                        <div class="bullet bg-success me-3"></div>
                                                        <div class="text-gray-900">Completed</div>
                                                        <div class="ms-auto fw-boldest text-gray-700">
                                                            <?php $counter=0; ?>
                                                            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if($order->status == 'Complete'): ?>
                                                            <?php $counter++; ?>
                                                            <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php echo e($counter); ?>

                                                        </div>
                                                    </div>
                                                    <!--end::Label-->
                                                    <!--begin::Label-->
                                                    <div class="d-flex fs-6 fw-bold align-items-center">
                                                        <div class="bullet bg-gray-300 me-3"></div>
                                                        <div class="text-gray-900">Yet to start</div>
                                                        <div class="ms-auto fw-boldest text-gray-700">
                                                            <?php $counter=0; ?>
                                                            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if($order->status == 'Pending'): ?>
                                                            <?php $counter++; ?>
                                                            <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php echo e($counter); ?>

                                                        </div>
                                                    </div>
                                                    <!--end::Label-->
                                                </div>
                                                <!--end::Labels-->
                                            </div>
                                            <!--end::Wrapper-->
                                        </div>
                                        <!--end::Body-->
                                    </div>
                                    <!--end::Slider widget 2-->
                                </div>
                                <!--end::Col-->
                            </div>
                            <!--end::Row-->
                        </div>
                        <!--end::Col-->
                        <!--begin::Col-->
                        <div class="col-xxl-4 gy-0 gy-xxl-8">
                            <!--begin::Engage Widget 1-->
                            <div class="card card-xxl-stretch mb-5 mb-xl-8">
                                <!--begin::Body-->
                                <div class="card-body p-0">
                                    <!--begin::Header-->
                                    <div class="px-9 pt-6 card-rounded h-250px w-100 bgi-no-repeat bgi-size-cover bgi-position-y-top h-200px"
                                        style="background-image: url('img/bg-green.png'); background-color: #00a3ff">
                                        <!--begin::Heading-->
                                        <div class="flex flex-stack">
                                            <h3 class="m-0 text-white fw-bolder fs-3">
                                                Quick Stats
                                            </h3>
                                        </div>
                                        <!--end::Heading-->
                                        <!--begin::Balance-->
                                        <div class="fw-bolder fs-7 text-center text-white pt-3">
                                            Company Balance
                                            <span class="fw-boldest fs-2hx d-block mt-n1">$ <?php echo e($companyBalance); ?></span>
                                        </div>
                                        <div class="fw-bolder fs-7 text-center text-white pt-3">
                                            Client's
                                            <span class="fw-boldest fs-2hx d-block mt-n1">$ <?php echo e($clientsCashflow); ?></span>
                                        </div>
                                        <div class="fw-bolder fs-7 text-center text-white pt-3">
                                            Writers
                                            <span class="fw-boldest fs-2hx d-block mt-n1">$ <?php echo e($writersCashflow); ?></span>
                                        </div>

                                        <!--end::Balance-->
                                    </div>
                                    <!--end::Header-->
                                    <!--begin::Items-->
                                    <div class="shadow-xs card-rounded mx-9 mb-9 px-6 py-9 position-relative z-index-1 bg-white"
                                        style="margin-top: 0px">
                                        <!--begin::Item-->
                                        <div class="d-flex align-items-center mb-9">
                                            <!--begin::Symbol-->
                                            <div class="symbol symbol-40px me-5">
                                                <span class="symbol-label">
                                                    <!--begin::Svg Icon | path: icons/stockholm/Home/Globe.svg-->
                                                    <span class="svg-icon svg-icon-gray-400 svg-icon-2">
                                                        <i class="bi bi-watch"></i>
                                                    </span>
                                                    <!--end::Svg Icon-->
                                                </span>
                                            </div>
                                            <!--end::Symbol-->
                                            <!--begin::Description-->
                                            <div class="d-flex align-items-center flex-wrap w-100">
                                                <!--begin::Title-->
                                                <div class="mb-1 pe-3 flex-grow-1">
                                                    <a href="<?php echo e(route('clients')); ?>"
                                                        class="fs-4 text-gray-800 text-hover-primary fw-boldest">Online Clients</a>
                                                    <div class="text-gray-900 fw-bold">

                                                    </div>
                                                </div>
                                                <!--end::Title-->
                                                <!--begin::Label-->
                                                <div class="d-flex align-items-center">
                                                    <div class="fw-bolder fs-4 text-gray-800 pe-1">
                                                        <?php echo e($onlineClients); ?>

                                                    </div>
                                                    <a href="#" class="btn btn-icon btn-sm me-n2">
                                                        <!--begin::Svg Icon | path: icons/stockholm/Navigation/Right-2.svg-->
                                                        <span class="svg-icon svg-icon-4 svg-icon-gray-400">
                                                            <i class="bi bi-chevron-right"></i>
                                                        </span>
                                                        <!--end::Svg Icon-->
                                                    </a>
                                                </div>
                                                <!--end::Label-->
                                            </div>
                                            <!--end::Description-->
                                        </div>
                                        <!--end::Item-->
                                        <!--begin::Item-->
                                        <div class="d-flex align-items-center mb-9">
                                            <!--begin::Symbol-->
                                            <div class="symbol symbol-40px me-5">
                                                <span class="symbol-label">
                                                    <!--begin::Svg Icon | path: icons/stockholm/Layout/Layout-4-blocks-2.svg-->
                                                    <span class="svg-icon svg-icon-gray-400 svg-icon-2">
                                                        <i class="bi bi-watch"></i>
                                                    </span>
                                                    <!--end::Svg Icon-->
                                                </span>
                                            </div>
                                            <!--end::Symbol-->
                                            <!--begin::Description-->
                                            <div class="d-flex align-items-center flex-wrap w-100">
                                                <!--begin::Title-->
                                                <div class="mb-1 pe-3 flex-grow-1">
                                                    <a href="<?php echo e(route('writers')); ?>"
                                                        class="fs-4 text-gray-800 text-hover-primary fw-boldest">Online Writers</a>
                                                    <div class="text-gray-900 fw-bold">

                                                    </div>
                                                </div>
                                                <!--end::Title-->
                                                <!--begin::Label-->
                                                <div class="d-flex align-items-center">
                                                    <div class="fw-bolder fs-4 text-gray-800 pe-1">
                                                        <?php echo e($onlineWriters); ?>

                                                    </div>
                                                    <a href="#" class="btn btn-icon btn-sm me-n2">
                                                        <!--begin::Svg Icon | path: icons/stockholm/Navigation/Right-2.svg-->
                                                        <span class="svg-icon svg-icon-4 svg-icon-gray-400">
                                                            <i class="bi bi-chevron-right"></i>
                                                        </span>
                                                        <!--end::Svg Icon-->
                                                    </a>
                                                </div>
                                                <!--end::Label-->
                                            </div>
                                            <!--end::Description-->
                                        </div>
                                        <!--end::Item-->
                                        <!--begin::Item-->
                                        <div class="d-flex align-items-center mb-9">
                                            <!--begin::Symbol-->
                                            <div class="symbol symbol-40px me-5">
                                                <span class="symbol-label">
                                                    <!--begin::Svg Icon | path: icons/stockholm/Devices/Watch2.svg-->
                                                    <span class="svg-icon svg-icon-gray-400 svg-icon-2">
                                                        <i class="bi bi-watch"></i>
                                                    </span>
                                                    <!--end::Svg Icon-->
                                                </span>
                                            </div>
                                            <!--end::Symbol-->
                                            <!--begin::Description-->
                                            <div class="d-flex align-items-center flex-wrap w-100">
                                                <!--begin::Title-->
                                                <div class="mb-1 pe-3 flex-grow-1">
                                                    <a href="<?php echo e(route('staff')); ?>"
                                                        class="fs-4 text-gray-800 text-hover-primary fw-boldest">Online Staff</a>
                                                    <div class="text-gray-900 fw-bold">

                                                    </div>
                                                </div>
                                                <!--end::Title-->
                                                <!--begin::Label-->
                                                <div class="d-flex align-items-center">
                                                    <div class="fw-bolder fs-4 text-gray-800 pe-1">
                                                        <?php echo e($onlineStaff); ?>

                                                    </div>
                                                    <a href="#" class="btn btn-icon btn-sm me-n2">
                                                        <!--begin::Svg Icon | path: icons/stockholm/Navigation/Right-2.svg-->
                                                        <span class="svg-icon svg-icon-4 svg-icon-gray-400">
                                                            <i class="bi bi-chevron-right"></i>
                                                        </span>
                                                        <!--end::Svg Icon-->
                                                    </a>
                                                </div>
                                                <!--end::Label-->
                                            </div>
                                            <!--end::Description-->
                                        </div>
                                        <!--end::Item-->
                                        <!--begin::Item-->
                                        
                                        <!--end::Item-->
                                    </div>
                                    <!--end::Items-->
                                </div>
                                <!--end::Body-->
                            </div>
                            <!--end::Engage Widget 1-->
                        </div>
                        <!--end::Col-->
                        <?php elseif($centerView=='revisions'): ?>
                        <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('admin.components.center-view')->html();
} elseif ($_instance->childHasBeenRendered('K0rgKrM')) {
    $componentId = $_instance->getRenderedChildComponentId('K0rgKrM');
    $componentTag = $_instance->getRenderedChildComponentTagName('K0rgKrM');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('K0rgKrM');
} else {
    $response = \Livewire\Livewire::mount('admin.components.center-view');
    $html = $response->html();
    $_instance->logRenderedChild('K0rgKrM', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                        <?php elseif($centerView=='pending'): ?>
                        <div class="row g-5 gx-xxl-8 mb-xxl-3">
                            <!--begin::Col-->
                            <div class="col-xxl-12">
                                <!--begin::Table widget 1-->
                                <div class="card card-xxl-stretch mb-5 mb-xl-3">
                                    <!--begin::Header-->
                                    <div class="card-header border-0 pt-5 pb-3">
                                        <!--begin::Heading-->
                                        <h3 class="card-title align-items-start flex-column">
                                            <span class="card-label fw-boldest text-gray-800 fs-2">Pending
                                                Orders</span>

                                            <span class="text-gray-900 fw-bold mt-2 fs-6">
                                                <?php echo e(count($pending_orders)); ?> Pending Order(s)
                                            </span>

                                        </h3>
                                        <!--end::Heading-->
                                        <!--begin::Toolbar-->
                                        <div class="card-toolbar">
                                            <!--begin::Search-->
                                            <div class="w-125px position-relative my-1">
                                                <!--begin::Svg Icon | path: icons/stockholm/General/Search.svg-->
                                                <span
                                                    class="svg-icon svg-icon-3 svg-icon-gray-500 position-absolute top-50 translate-middle ms-6">
                                                    <i class="bi bi-search"></i>
                                                </span>
                                                <!--end::Svg Icon-->
                                                <input type="text"
                                                    class="form-control form-control-sm form-control-solid ps-10"
                                                    name="search" value="" placeholder="Search" />
                                            </div>
                                            <!--end::Search-->
                                        </div>
                                        <!--end::Toolbar-->
                                    </div>
                                    <!--end::Header-->
                                    <!--begin::Body-->
                                    <div class="card-body py-0">
                                        <!--begin::Table-->
                                        <div class="table-responsive">
                                            <table
                                                class="table align-middle table-row-bordered table-row-dashed gy-5"
                                                id="kt_table_widget_1" x-data=''>
                                                <thead
                                                    class="border-bottom border-gray-200 fs-5 fw-bold bg-light bg-opacity-75">
                                                    <tr>
                                                        <th class="w-20px ps-0">
                                                            <div
                                                                class="form-check form-check-sm form-check-custom form-check-solid me-5">
                                                                <input class="form-check-input" type="checkbox"
                                                                    data-kt-check="true"
                                                                    data-kt-check-target="#kt_table_widget_1 .form-check-input"
                                                                    value="1" />
                                                            </div>
                                                        </th>
                                                        <?php $__currentLoopData = $cols; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $col): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if($col['isList'] == true): ?>
                                                        <th class=""><?php echo e($col['colCaption']); ?></th>
                                                        <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <th class="text-end pe-2 min-w-70px">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php if(count($pending_orders) > 0): ?>
                                                    <?php $__currentLoopData = $pending_orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $pending_order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>

                                                        <td class="p-0">
                                                            <div
                                                                class="form-check form-check-sm form-check-custom form-check-solid">
                                                                <input class="form-check-input" type="checkbox"
                                                                    value="1"
                                                                    x-on:click="$wire.select('<?php echo e($pending_order[$keyCol]); ?>')"
                                                                    <?php echo e($isSelectAll? 'checked':''); ?> />
                                                            </div>
                                                        </td>
                                                        <?php $__currentLoopData = $cols; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $col): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if($col['isList'] == true): ?>
                                                        <?php if(isset($col['isKey'])): ?>
                                                        <td class="p-0"
                                                            x-on:click="$wire.view('<?php echo e($pending_order[$keyCol]); ?>')">
                                                            <div class="d-flex align-items-center">
                                                                <div class="ps-3">
                                                                    <a href="#"
                                                                        class="text-gray-900 mb-1"><?php echo e($pending_order[$col['colName']]); ?>

                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <?php else: ?>
                                                        <?php if($col['type'] == 'date'): ?>
                                                        <td class="p-0">
                                                            <div class="d-flex align-items-center">
                                                                <div class="ps-3">
                                                                    <a href="#"
                                                                        class="text-gray-500  fs-5  mb-1"><?php echo htmlspecialchars_decode(date('j<\s\up>S
                                                                        </\s\up> F Y',
                                                                        strtotime($pending_order[$col['colName']]))); ?>

                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <?php elseif(isset($col['isRelationship']) &&
                                                        $col['isRelationship'] == true): ?>
                                                        <td class="p-0">
                                                            <div class="d-flex align-items-center">
                                                                <div class="ps-3">
                                                                    <a href="#" class="text-gray-900 mb-1">
                                                                        <?php echo e($pending_order[$col['relName']][$col['colName']]); ?>

                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <?php elseif($col['colName'] == 'status'): ?>
                                                        <td>
                                                            <div class="d-flex flex-column w-100 me-2 mt-2 ">
                                                                <span
                                                                    class="text-red-400 me-2 fw-boldest mb-2 text-danger"><?php echo e($pending_order[$col['colName']]); ?></span>
                                                            </div>
                                                        </td>
                                                        <?php else: ?>
                                                        <td class="p-0">
                                                            <div class="d-flex align-items-center">
                                                                <div class="ps-3">
                                                                    <a href="#" class="text-gray-900 mb-1">
                                                                        <?php echo e($pending_order[$col['colName']]); ?>

                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <?php endif; ?>
                                                        <?php endif; ?>
                                                        <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                        <td class="pe-0 text-end">
                                                            <a class="btn btn-light text-muted fw-boldest text-hover-primary btn-sm px-5"
                                                                x-on:click="$wire.chat('<?php echo e($pending_order[$keyCol]); ?>')">View</a>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php else: ?>
                                                    <tr>
                                                        <td class="italic text-center" colspan="<?php echo e(count($cols)); ?>">
                                                            <br>*** No records
                                                            found ***</td>
                                                    </tr>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                        </div>

                                        <!--end::Table-->
                                    </div>
                                    <!--end::Body-->
                                </div>
                                <!--end::Table widget 1-->
                                <?php echo e($pending_orders->links('components.pagination-links')); ?>

                            </div>
                            <!--end::Col-->
                        </div>
                        <?php elseif($centerView=='cancelled'): ?>
                        <div class="row g-5 gx-xxl-8 mb-xxl-3">
                            <!--begin::Col-->
                            <div class="col-xxl-12">
                                <!--begin::Table widget 1-->
                                <div class="card card-xxl-stretch mb-5 mb-xl-3">
                                    <!--begin::Header-->
                                    <div class="card-header border-0 pt-5 pb-3">
                                        <!--begin::Heading-->
                                        <h3 class="card-title align-items-start flex-column">
                                            <span class="card-label fw-boldest text-gray-800 fs-2">Cancelled Orders</span>
                                            <span class="text-gray-900 fw-bold mt-2 fs-6"><?php echo e(count($cancelled)); ?>

                                                Order(s)</span>
                                        </h3>
                                        <!--end::Heading-->
                                        <!--begin::Toolbar-->
                                        <div class="card-toolbar">
                                            <!--begin::Search-->
                                            <div class="w-125px position-relative my-1">
                                                <!--begin::Svg Icon | path: icons/stockholm/General/Search.svg-->
                                                <span
                                                    class="svg-icon svg-icon-3 svg-icon-gray-500 position-absolute top-50 translate-middle ms-6">
                                                    <i class="bi bi-search"></i>
                                                </span>
                                                <!--end::Svg Icon-->
                                                <input type="text"
                                                    class="form-control form-control-sm form-control-solid ps-10"
                                                    name="search" value="" placeholder="Search" />
                                            </div>
                                            <!--end::Search-->
                                        </div>
                                        <!--end::Toolbar-->
                                    </div>
                                    <!--end::Header-->
                                    <!--begin::Body-->
                                    <div class="card-body py-0">
                                        <!--begin::Table-->
                                        <div class="table-responsive">
                                            <table
                                                class="table align-middle table-row-bordered table-row-dashed gy-5"
                                                id="kt_table_widget_1" x-data=''>
                                                <thead
                                                    class="border-bottom border-gray-200 fs-5 fw-bold bg-light bg-opacity-75">
                                                    <tr>
                                                        <th class="w-20px ps-0">
                                                            <div
                                                                class="form-check form-check-sm form-check-custom form-check-solid me-5">
                                                                <input class="form-check-input" type="checkbox"
                                                                    data-kt-check="true"
                                                                    data-kt-check-target="#kt_table_widget_1 .form-check-input"
                                                                    value="1" />
                                                            </div>
                                                        </th>
                                                        <th class="min-w-125px">Date</th>
                                                        <th class="min-w-180px">Order ID</th>
                                                        <th class="min-w-125px">Details</th>
                                                        <th class="min-w-120px">Status</th>
                                                        <th class="text-end pe-2 min-w-70px">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php if(count($cancelled) > 0): ?>
                                                    <?php $__currentLoopData = $cancelled; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cancel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td class="p-0">
                                                            <div
                                                                class="form-check form-check-sm form-check-custom form-check-solid">
                                                                <input class="form-check-input" type="checkbox"
                                                                    value="1" />
                                                            </div>
                                                        </td>
                                                        <td class="p-0">
                                                            <div class="d-flex align-items-center">
                                                                <div class="ps-3">
                                                                    <a href="#"
                                                                        class="text-gray-500  fs-5  mb-1"><?php echo htmlspecialchars_decode(date('j<\s\up>S
                                                                        </\s\up> F Y',
                                                                        strtotime($cancel->created_at))); ?>

                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td class="p-0">
                                                            <div class="d-flex align-items-center">
                                                                <div class="ps-3">
                                                                    <a href="#"
                                                                        class="text-gray-900 mb-1"><?php echo e($cancel->order_no); ?>

                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td class="p-0">
                                                            <div class="d-flex align-items-center">
                                                                <div class="ps-3">
                                                                    <a href="#"
                                                                        class="text-gray-900 mb-1"><?php echo e($cancel->topic); ?>

                                                                    </a>
                                                                </div>
                                                            </div>
                                                            
                                                        </td>
                                                        <td>
                                                            <div class="d-flex flex-column w-100 me-2 mt-2 ">
                                                                <span
                                                                    class="text-red-400 me-2 fw-boldest mb-2 text-danger"><?php echo e($cancel->status); ?></span>
                                                            </div>
                                                        </td>
                                                        <td class="pe-0 text-end">
                                                            <a class="btn btn-light text-muted fw-boldest text-hover-primary btn-sm px-5"
                                                                x-on:click="$wire.chat('<?php echo e($cancel->order_no); ?>')">View</a>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php else: ?>

                                                    <tr>

                                                        <td colspan="6" class="pe-0 text-end italic text-center" >
                                                            *** No records
                                                            found ***
                                                        </td>
                                                    </tr>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                        <!--end::Table-->
                                    </div>
                                    <!--end::Body-->
                                </div>
                                <!--end::Table widget 1-->
                                <?php echo e($cancled->links('components.pagination-links')); ?>

                            </div>
                            <!--end::Col-->
                        </div>
                        <?php elseif($centerView == 'In Progress'): ?>
                        <div class="row g-5 gx-xxl-8 mb-xxl-3">
                            <!--begin::Col-->
                            <div class="col-xxl-12">
                                <!--begin::Table widget 1-->
                                <div class="card card-xxl-stretch mb-5 mb-xl-3">
                                    <!--begin::Header-->
                                    <div class="card-header border-0 pt-5 pb-3">
                                        <!--begin::Heading-->
                                        <h3 class="card-title align-items-start flex-column">
                                            <span class="card-label fw-boldest text-gray-800 fs-2">Orders In Progress</span>
                                            <span class="text-gray-900 fw-bold mt-2 fs-6"><?php echo e(count($progress_orders)); ?>

                                                 Order(s)</span>
                                        </h3>
                                        <!--end::Heading-->
                                        <!--begin::Toolbar-->
                                        <div class="card-toolbar">
                                            <!--begin::Search-->
                                            <div class="w-125px position-relative my-1">
                                                <!--begin::Svg Icon | path: icons/stockholm/General/Search.svg-->
                                                <span
                                                    class="svg-icon svg-icon-3 svg-icon-gray-500 position-absolute top-50 translate-middle ms-6">
                                                    <i class="bi bi-search"></i>
                                                </span>
                                                <!--end::Svg Icon-->
                                                <input type="text"
                                                    class="form-control form-control-sm form-control-solid ps-10"
                                                    name="search" value="" placeholder="Search" />
                                            </div>
                                            <!--end::Search-->
                                        </div>
                                        <!--end::Toolbar-->
                                    </div>
                                    <!--end::Header-->
                                    <!--begin::Body-->
                                    <div class="card-body py-0">
                                        <!--begin::Table-->
                                        <div class="table-responsive">
                                            <table
                                                class="table align-middle table-row-bordered table-row-dashed gy-5"
                                                id="kt_table_widget_1" x-data=''>
                                                <thead
                                                    class="border-bottom border-gray-200 fs-5 fw-bold bg-light bg-opacity-75">
                                                    <tr>
                                                        <th class="w-20px ps-0">
                                                            <div
                                                                class="form-check form-check-sm form-check-custom form-check-solid me-5">
                                                                <input class="form-check-input" type="checkbox"
                                                                    data-kt-check="true"
                                                                    data-kt-check-target="#kt_table_widget_1 .form-check-input"
                                                                    value="1" />
                                                            </div>
                                                        </th>
                                                        <th class="min-w-125px">Deadline</th>
                                                        <th class="min-w-180px">Order ID</th>
                                                        <th class="min-w-125px">Details</th>
                                                        <th class="min-w-125px">Price</th>
                                                        <th class="min-w-120px">Progress</th>
                                                        <th class="text-start pe-2 min-w-70px">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php if(count($active) > 0): ?>
                                                    <?php $__currentLoopData = $active; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $progress_order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td class="p-0">
                                                            <div
                                                                class="form-check form-check-sm form-check-custom form-check-solid">
                                                                <input class="form-check-input" type="checkbox"
                                                                    value="1" />
                                                            </div>
                                                        </td>
                                                        <td class="p-0">
                                                            <div class="d-flex align-items-center">
                                                                <div class="ps-3">
                                                                    <a href="#"
                                                                        class="text-gray-500  fs-5  mb-1"><?php echo htmlspecialchars_decode(date('j<\s\up>S
                                                                        </\s\up> F Y',
                                                                        strtotime($progress_order->created_at))); ?>

                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td class="p-0">
                                                            <div class="d-flex align-items-center">
                                                                <div class="ps-3">
                                                                    <a href="#"
                                                                        class="text-gray-900 mb-1"><?php echo e($progress_order->order->order_no); ?>

                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td class="p-0">
                                                            <div class="d-flex align-items-center">
                                                                <div class="ps-3">
                                                                    <a href="#"
                                                                        class="text-gray-900 mb-1"><?php echo e($progress_order->order->topic); ?>

                                                                    </a>
                                                                </div>
                                                            </div>
                                                            
                                                        </td>
                                                        <td class="p-0">
                                                            <div class="d-flex align-items-center">
                                                                <div class="ps-3">
                                                                    <a href="#"
                                                                        class="text-gray-900 mb-1">$ <?php echo e($progress_order->amount); ?>

                                                                    </a>
                                                                </div>
                                                            </div>
                                                            
                                                        </td>
                                                        <td>
                                                            <div class="d-flex flex-column w-100 me-2 mt-2">

                                                                <?php if($progress_order->order->status=='In progress'): ?>
                                                                <span
                                                                    wire:class="text-gray-900 me-2 fw-boldest mb-2">85%</span>
                                                                <div class="progress bg-light-info w-100 h-5px">
                                                                    <div class="progress-bar bg-info"
                                                                        role="progressbar" style="width: 85%"></div>
                                                                </div>

                                                                <?php endif; ?>
                                                            </div>
                                                        </td>
                                                        <td class="pe-0 text-start">
                                                            <a class="btn btn-light text-muted fw-boldest text-hover-primary btn-sm px-5"
                                                                x-on:click="$wire.chat('<?php echo e($progress_order->order->order_no); ?>')">View</a>
                                                            <?php if($progress_order->order->publish == 0): ?>
                                                            <a class="btn btn-light text-muted fw-boldest text-hover-primary btn-sm px-5"
                                                            x-data="{}" x-on:click="$dispatch('dlg-modal');$wire.publishOrder(<?php echo e($progress_order->order->id); ?>, '<?php echo e($progress_order->amount); ?>')">Publish Order</a>
                                                            <?php endif; ?>
                                                            <a class="btn btn-light text-muted fw-boldest text-hover-primary btn-sm px-5"
                                                                x-on:click="$wire.bids('<?php echo e($progress_order->order->id); ?>')">View Bids</a>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php else: ?>
                                                    <tr>
                                                        <td class="pe-0 text-end italic text-center" >
                                                            <br>*** No records
                                                            found ***</td>
                                                    </tr>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                            <div x-data="{isDlgModal:false}" :class="{ 'block': isDlgModal, 'hidden': !isDlgModal }"
                                            class="hidden" x-on:dlg-modal.window="isDlgModal = !isDlgModal"
                                            @click.away="isDlgModal = false">
                                            <?php echo $__env->make('livewire.general.global-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </div>
                                        </div>
                                        <!--end::Table-->
                                    </div>
                                    <!--end::Body-->
                                </div>
                                <!--end::Table widget 1-->
                                <?php echo e($active->links('components.pagination-links')); ?>

                            </div>
                            <!--end::Col-->
                        </div>
                        <?php elseif($centerView == 'Completed'): ?>
                        <div class="row g-5 gx-xxl-8 mb-xxl-3">
                            <!--begin::Col-->
                            <div class="col-xxl-12">
                                <!--begin::Table widget 1-->
                                <div class="card card-xxl-stretch mb-5 mb-xl-3">
                                    <!--begin::Header-->
                                    <div class="card-header border-0 pt-5 pb-3">
                                        <!--begin::Heading-->
                                        <h3 class="card-title align-items-start flex-column">
                                            <span class="card-label fw-boldest text-gray-800 fs-2">Completed Orders</span>
                                            <span class="text-gray-900 fw-bold mt-2 fs-6"><?php echo e(count($complete)); ?>

                                                Order(s)</span>
                                        </h3>
                                        <!--end::Heading-->
                                        <!--begin::Toolbar-->
                                        <div class="card-toolbar">
                                            <!--begin::Search-->
                                            <div class="w-125px position-relative my-1">
                                                <!--begin::Svg Icon | path: icons/stockholm/General/Search.svg-->
                                                <span
                                                    class="svg-icon svg-icon-3 svg-icon-gray-500 position-absolute top-50 translate-middle ms-6">
                                                    <i class="bi bi-search"></i>
                                                </span>
                                                <!--end::Svg Icon-->
                                                <input type="text"
                                                    class="form-control form-control-sm form-control-solid ps-10"
                                                    name="search" value="" placeholder="Search" />
                                            </div>
                                            <!--end::Search-->
                                        </div>
                                        <!--end::Toolbar-->
                                    </div>
                                    <!--end::Header-->
                                    <!--begin::Body-->
                                    <div class="card-body py-0">
                                        <!--begin::Table-->
                                        <div class="table-responsive">
                                            <table
                                                class="table align-middle table-row-bordered table-row-dashed gy-5"
                                                id="kt_table_widget_1" x-data=''>
                                                <thead
                                                    class="border-bottom border-gray-200 fs-5 fw-bold bg-light bg-opacity-75">
                                                    <tr>
                                                        <th class="w-20px ps-0">
                                                            <div
                                                                class="form-check form-check-sm form-check-custom form-check-solid me-5">
                                                                <input class="form-check-input" type="checkbox"
                                                                    data-kt-check="true"
                                                                    data-kt-check-target="#kt_table_widget_1 .form-check-input"
                                                                    value="1" />
                                                            </div>
                                                        </th>
                                                        <th class="min-w-125px">Date</th>
                                                        <th class="min-w-180px">Order ID</th>
                                                        <th class="min-w-125px">Details</th>
                                                        <th class="min-w-120px">Progress</th>
                                                        <th class="text-end pe-2 min-w-70px">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php if(count($complete) > 0): ?>
                                                    <?php $__currentLoopData = $complete; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $done): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td class="p-0">
                                                            <div
                                                                class="form-check form-check-sm form-check-custom form-check-solid">
                                                                <input class="form-check-input" type="checkbox"
                                                                    value="1" />
                                                            </div>
                                                        </td>
                                                        <td class="p-0">
                                                            <div class="d-flex align-items-center">
                                                                <div class="ps-3">
                                                                    <a href="#"
                                                                        class="text-gray-500  fs-5  mb-1"><?php echo htmlspecialchars_decode(date('j<\s\up>S
                                                                        </\s\up> F Y',
                                                                        strtotime($done->created_at))); ?>

                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td class="p-0">
                                                            <div class="d-flex align-items-center">
                                                                <div class="ps-3">
                                                                    <a href="#"
                                                                        class="text-gray-900 mb-1"><?php echo e($done->order_no); ?>

                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td class="p-0">
                                                            <div class="d-flex align-items-center">
                                                                <div class="ps-3">
                                                                    <a href="#"
                                                                        class="text-gray-900 mb-1"><?php echo e($done->topic); ?>

                                                                    </a>
                                                                </div>
                                                            </div>
                                                            
                                                        </td>
                                                        <td>
                                                            <div class="d-flex flex-column w-100 me-2 mt-2">

                                                                <?php if($done->status=='Complete'): ?>
                                                                <span
                                                                    wire:class="text-gray-900 me-2 fw-boldest mb-2">100%</span>
                                                                <div class="progress bg-light-info w-100 h-5px">
                                                                    <div class="progress-bar bg-success"
                                                                        role="progressbar" style="width: 100%"></div>
                                                                </div>

                                                                <?php endif; ?>
                                                            </div>
                                                        </td>
                                                        <td class="pe-0 text-end">
                                                            <a class="btn btn-light text-muted fw-boldest text-hover-primary btn-sm px-5"
                                                                x-on:click="$wire.chat('<?php echo e($done->order_no); ?>')">View</a>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php else: ?>
                                                    <tr>
                                                        <td colspan="6" class="pe-0 text-end italic text-center" >
                                                            *** No records
                                                            found ***
                                                        </td>
                                                    </tr>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                        <!--end::Table-->
                                    </div>
                                    <!--end::Body-->
                                </div>
                                <!--end::Table widget 1-->
                                <?php echo e($complete->links('components.pagination-links')); ?>

                            </div>
                            <!--end::Col-->
                        </div>
                        <?php elseif($centerView == 'ongoing revisions'): ?>
                        <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('admin.components.center-view')->html();
} elseif ($_instance->childHasBeenRendered('KvxMHqi')) {
    $componentId = $_instance->getRenderedChildComponentId('KvxMHqi');
    $componentTag = $_instance->getRenderedChildComponentTagName('KvxMHqi');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('KvxMHqi');
} else {
    $response = \Livewire\Livewire::mount('admin.components.center-view');
    $html = $response->html();
    $_instance->logRenderedChild('KvxMHqi', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                        <?php elseif($centerView == 'done revisions'): ?>
                        <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('admin.components.center-view')->html();
} elseif ($_instance->childHasBeenRendered('Klk4a57')) {
    $componentId = $_instance->getRenderedChildComponentId('Klk4a57');
    $componentTag = $_instance->getRenderedChildComponentTagName('Klk4a57');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('Klk4a57');
} else {
    $response = \Livewire\Livewire::mount('admin.components.center-view');
    $html = $response->html();
    $_instance->logRenderedChild('Klk4a57', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                        <?php elseif($centerView == 'bidders'): ?>
                        <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('admin.order.order-bids')->html();
} elseif ($_instance->childHasBeenRendered('bb9b9Sg')) {
    $componentId = $_instance->getRenderedChildComponentId('bb9b9Sg');
    $componentTag = $_instance->getRenderedChildComponentTagName('bb9b9Sg');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('bb9b9Sg');
} else {
    $response = \Livewire\Livewire::mount('admin.order.order-bids');
    $html = $response->html();
    $_instance->logRenderedChild('bb9b9Sg', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                        <?php elseif($centerView == 'bid-details'): ?>
                        <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('admin.order.bid-details')->html();
} elseif ($_instance->childHasBeenRendered('X5XImt4')) {
    $componentId = $_instance->getRenderedChildComponentId('X5XImt4');
    $componentTag = $_instance->getRenderedChildComponentTagName('X5XImt4');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('X5XImt4');
} else {
    $response = \Livewire\Livewire::mount('admin.order.bid-details');
    $html = $response->html();
    $_instance->logRenderedChild('X5XImt4', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                        <?php endif; ?>

                </div>
                <!--end::Row-->
                <!--end::Row-->
            </div>
            <!--end::Container-->
        </div>
        <!--end::Post-->
    </div>
    <?php elseif($varView=='jobs'): ?>
    <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('admin.job')->html();
} elseif ($_instance->childHasBeenRendered('BMfzhOH')) {
    $componentId = $_instance->getRenderedChildComponentId('BMfzhOH');
    $componentTag = $_instance->getRenderedChildComponentTagName('BMfzhOH');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('BMfzhOH');
} else {
    $response = \Livewire\Livewire::mount('admin.job');
    $html = $response->html();
    $_instance->logRenderedChild('BMfzhOH', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
    <?php elseif($varView == 'chat'): ?>
    <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('client.chat-order-summary')->html();
} elseif ($_instance->childHasBeenRendered('dCAmiKw')) {
    $componentId = $_instance->getRenderedChildComponentId('dCAmiKw');
    $componentTag = $_instance->getRenderedChildComponentTagName('dCAmiKw');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('dCAmiKw');
} else {
    $response = \Livewire\Livewire::mount('client.chat-order-summary');
    $html = $response->html();
    $_instance->logRenderedChild('dCAmiKw', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
    <?php endif; ?>
    <!--end::Content-->
</div>
<style>
 .card{

 }
</style>
<?php /**PATH C:\xampp\htdocs\Nariphon_Technologies\typewriter\resources\views/livewire/admin/admin-dashboard.blade.php ENDPATH**/ ?>