<?php if($paginator->hasPages()): ?>
<ul class="flex items-center my-6 pb-5">
    <?php if($paginator->onFirstPage()): ?>
    <?php else: ?>
        <li dusk="previousPage"  wire:click="previousPage" wire:loading.attr="disabled" rel="prev" class="mx-1 px-3 py-2 bg-gray-200 text-gray-500 rounded-lg">
            <a class="flex items-center font-bold" href="#">
                <span class="mx-1">Previous</span>
            </a>
        </li>
    <?php endif; ?>

    <?php $__currentLoopData = $elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if(is_string($element)): ?>
            <li class="mx-1 px-3 py-2 bg-gray-200 text-gray-700 hover:bg-gray-700 hover:text-gray-200 rounded-lg">
                <a class="font-bold" href="#"><?php echo e($element); ?></a>
            </li>
        <?php endif; ?>
        <?php if(is_array($element)): ?>
            <?php $__currentLoopData = $element; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($page == $paginator->currentPage()): ?>
                <li wire:key="paginator-page-<?php echo e($page); ?>" aria-current="page" class="mx-1 px-3 py-2 bg-gray-700 text-gray-200  rounded-lg">
                    <a class="font-bold" href="#"><?php echo e($page); ?></a>
                </li>
                <?php else: ?>
                <li wire:click='gotoPage(<?php echo e($page); ?>)' class="mx-1 px-3 py-2 bg-gray-200 text-gray-700 hover:bg-gray-700 hover:text-gray-200 rounded-lg">
                    <a class="font-bold" href="#"><?php echo e($page); ?></a>
                </li>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


    <?php if($paginator->hasMorePages()): ?>
    <li wire:click="nextPage" wire:loading.attr="disabled" class="mx-1 px-3 py-2 bg-gray-200 text-gray-700 hover:bg-gray-700 hover:text-gray-200 rounded-lg">
        <a class="flex items-center font-bold" href="#">
            <span class="mx-1">Next</span>
        </a>
    </li>
    <?php else: ?>
    <?php endif; ?>

</ul>
<?php endif; ?>
<?php /**PATH C:\xampp\htdocs\Nariphon_Technologies\typewriter\resources\views/components/pagination-links.blade.php ENDPATH**/ ?>