<div>
    <div wire:loading>
        <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('general.loader')->html();
} elseif ($_instance->childHasBeenRendered('7HO3ajH')) {
    $componentId = $_instance->getRenderedChildComponentId('7HO3ajH');
    $componentTag = $_instance->getRenderedChildComponentTagName('7HO3ajH');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('7HO3ajH');
} else {
    $response = \Livewire\Livewire::mount('general.loader');
    $html = $response->html();
    $_instance->logRenderedChild('7HO3ajH', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
    </div>
    <!-- Start Navigation -->
    <div class="header header-transparent dark-text">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12">
                    <nav id="navigation" class="navigation navigation-landscape">
                        <div class="nav-header">
                            <a class="nav-brand" href="<?php echo e(route('home')); ?>">
                                <img src="assets/img/logo.png" class="logo" alt="" />
                            </a>
                            <div class="nav-toggle"></div>
                        </div>
                        <div class="nav-menus-wrapper">
                            <ul class="nav-menu">
                                <li class="active"><a href="#">How it works</a></li>
                                <li class="active"><a href="#">Blog</a></li>
                                <li class="active"><a href="#">About Us</a></li>
                                <li class="active"><a href="#">Contact Us</a></li>
                            </ul>

                            <ul class="nav-menu nav-menu-social align-to-right">
                                <?php if(session()->get('LoggedClient') != null): ?>
                                <li class="add-listing dark-bg">
                                    <a href="<?php echo e(route('dashboard')); ?>" >
                                        <i class="ti-user mr-1"></i> Dashboard
                                    </a>
                                </li>
                                <li class="order add-listing dark-bg">
                                    <a href="<?php echo e(route('create-order')); ?>" >
                                        <i class="ti-user mr-1"></i> Order Now
                                    </a>
                                </li>
                                <?php elseif(session()->get('AuthWriter') != null): ?>
                                <li class="add-listing dark-bg">
                                    <a href="<?php echo e(route('writer-dashboard')); ?>" >
                                        <i class="ti-user mr-1"></i> Dashboard
                                    </a>
                                </li>
                                <li class="order add-listing dark-bg">
                                    <a href="<?php echo e(route('create-order')); ?>" >
                                        <i class="ti-user mr-1"></i> Order Now
                                    </a>
                                </li>
                                <?php elseif(auth()->user() != null): ?>
                                <?php if(session()->has('InactiveAccount')): ?>
                                    <?php if(session()->get('InactiveAccount')): ?>
                                    <li class="add-listing dark-bg">
                                        <form action="<?php echo e(route('logout')); ?>" method="post">
                                            <?php echo csrf_field(); ?>
                                            <a href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();
                                            this.closest('form').submit();">
                                                <i class="ti-user mr-1"></i> Logout
                                            </a>
                                        </form>
                                    </li>
                                    <?php else: ?>
                                    <li class="add-listing dark-bg">
                                        <a href="<?php echo e(route('admin-dashboard')); ?>" >
                                            <i class="ti-user mr-1"></i> Dashboard
                                        </a>
                                    </li>
                                    <?php endif; ?>
                                <?php else: ?>

                                <?php endif; ?>

                                <?php else: ?>
                                <li>
                                    <a href="<?php echo e(route('writer-login')); ?>" style="color: black !important;">
                                        <i class="fa fa-upload mr-1"></i>For Writers
                                    </a>
                                </li>
                                <li class="add-listing dark-bg">
                                    <a href="<?php echo e(route('dashboard')); ?>" >
                                        <i class="ti-user mr-1"></i> Sign in
                                    </a>
                                </li>
                                <li class="order add-listing dark-bg">
                                    <a href="<?php echo e(route('create-order')); ?>" >
                                        <i class="ti-user mr-1"></i> Order Now
                                    </a>
                                </li>
                                <?php endif; ?>

                            </ul>
                        </div>
                    </nav>
                </div>
            </div>
        </div>
    </div>
    <!-- End Navigation -->
    <style>
        @media(max-width :800px){
            .order{
                margin-top: 1rem;
            }
            .add-listing:hover a{
                color:white !important;
            }
        }
    </style>
</div>
<?php /**PATH C:\xampp\htdocs\Nariphon_Technologies\typewriter\resources\views/livewire/inc/nav-menu.blade.php ENDPATH**/ ?>