<div>
    
    <div wire:loading>
        <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('general.loader')->html();
} elseif ($_instance->childHasBeenRendered('TGUGbP0')) {
    $componentId = $_instance->getRenderedChildComponentId('TGUGbP0');
    $componentTag = $_instance->getRenderedChildComponentTagName('TGUGbP0');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('TGUGbP0');
} else {
    $response = \Livewire\Livewire::mount('general.loader');
    $html = $response->html();
    $_instance->logRenderedChild('TGUGbP0', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
    </div>
    <?php if($varView == ''): ?>
    <div class="content fs-6 d-flex flex-column flex-column-fluid" id="kt_content">
        <!--begin::Toolbar-->
        <div class="toolbar" id="kt_toolbar">
            <div class="container-fluid d-flex flex-stack flex-wrap flex-sm-nowrap">
                <!--begin::Info-->
                <div class="d-flex flex-column align-items-start justify-content-center flex-wrap me-2">
                    <!--begin::Title-->
                    <h1 class="text-dark fw-bolder my-1 fs-2">
                        Dashboard
                        <small class="text-muted fs-6 fw-normal ms-1"></small>
                    </h1>
                    <!--end::Title-->
                </div>

                <?php if(session()->has('Invoice-Confirmed')): ?>
                <div class="alert alert-success">
                    <?php echo e(session('Invoice-Confirmed')); ?>

                </div>
                <?php elseif(session()->has('Invoice-Rejected')): ?>
                <div class="alert alert-danger">
                    <?php echo e(session('Invoice-Rejected')); ?>

                </div>
                <?php endif; ?>

                <?php if(session()->has('success')): ?>
                <div class="m-auto">
                    <div class="bg-white rounded-lg border-gray-300 border p-3 shadow-lg">
                        <div class="flex flex-row">
                            <div class="px-2">
                                <svg width="24" height="24" viewBox="0 0 1792 1792" fill="#44C997" xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M1299 813l-422 422q-19 19-45 19t-45-19l-294-294q-19-19-19-45t19-45l102-102q19-19 45-19t45 19l147 147 275-275q19-19 45-19t45 19l102 102q19 19 19 45t-19 45zm141 83q0-148-73-273t-198-198-273-73-273 73-198 198-73 273 73 273 198 198 273 73 273-73 198-198 73-273zm224 0q0 209-103 385.5t-279.5 279.5-385.5 103-385.5-103-279.5-279.5-103-385.5 103-385.5 279.5-279.5 385.5-103 385.5 103 279.5 279.5 103 385.5z" />
                                </svg>
                            </div>
                            <div class="">
                                <span class="font-semibold"> <?php echo e(session('success-modal')); ?></span>
                                
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <?php if(session()->has('error')): ?>
                <div class="m-auto">
                    <div class="bg-danger rounded-lg border-gray-300 border p-3 shadow-lg"
                        style="background-color: rgba(224,52,18,.1) !important; color: rgba(224,52,18,.5);">
                        <div class="flex flex-row">
                            <div class="px-2 text-damger">
                                <i class="text-danger fas fa-times-circle fa-2x"></i>
                            </div>
                            <div class="">
                                <span class="font-semibold text-danger"> <?php echo e(session('error-modal')); ?></span>
                                
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <!--end::Info-->
                <!--begin::Actions-->
                
                <!--end::Actions-->
            </div>
        </div>
        <!--end::Toolbar-->
        <!--How it Works-->
        <div class="w-full py-6">
            <div class="flex">
              <div class="w-1/4">
                <div class="relative mb-2">
                  <div class="w-10 h-10 mx-auto bg-green-500 rounded-full text-lg text-white flex items-center">
                    <span class="text-center text-white w-full">
                      1
                    </span>
                  </div>
                </div>

                <div class="text-xs text-center md:text-base">Newly Created Orders Are Under Pending Orders</div>
              </div>

              <div class="w-1/4">
                <div class="relative mb-2">
                  <div class="absolute flex align-center items-center align-middle content-center" style="width: calc(100% - 2.5rem - 1rem); top: 50%; transform: translate(-50%, -50%)">
                    <div class="w-full bg-gray-200 rounded items-center align-middle align-center flex-1">
                      <div class="w-0 bg-green-300 py-1 rounded" style="width: 100%;"></div>
                    </div>
                  </div>

                  <div class="w-10 h-10 mx-auto bg-green-500 rounded-full text-lg text-white flex items-center">
                    <span class="text-center text-white w-full">
                      2
                    </span>
                  </div>
                </div>

                <div class="text-xs text-center md:text-base">Confirm Order By Clicking <strong>"View"</strong> Button</div>
              </div>

              <div class="w-1/4">
                <div class="relative mb-2">
                  <div class="absolute flex align-center items-center align-middle content-center" style="width: calc(100% - 2.5rem - 1rem); top: 50%; transform: translate(-50%, -50%)">
                    <div class="w-full bg-gray-200 rounded items-center align-middle align-center flex-1">
                      <div class="w-0 bg-green-300 py-1 rounded" style="width: 100%;"></div>
                    </div>
                  </div>

                  <div class="w-10 h-10 mx-auto bg-green-500 rounded-full text-lg text-white flex items-center">
                    <span class="text-center text-white w-full">
                      3
                    </span>
                  </div>
                </div>

                <div class="text-xs text-center md:text-base">Negotiate Price Under Chat Section</div>
              </div>

              <div class="w-1/4">
                <div class="relative mb-2">
                  <div class="absolute flex align-center items-center align-middle content-center" style="width: calc(100% - 2.5rem - 1rem); top: 50%; transform: translate(-50%, -50%)">
                    <div class="w-full bg-gray-200 rounded items-center align-middle align-center flex-1">
                      <div class="w-0 bg-green-300 py-1 rounded" style="width: 100%;"></div>
                    </div>
                  </div>

                  <div class="w-10 h-10 mx-auto bg-green-500 rounded-full text-lg text-white flex items-center">
                    <span class="text-center text-white w-full">
                      4
                    </span>
                  </div>
                </div>

                <div class="text-xs text-center md:text-base">Confirm Invoice To Move Your Order In Progress</div>
              </div>
            </div>
        </div>
        <!--End How it Works-->
        <!--begin::Post-->
        <div class="post fs-6 d-flex flex-column-fluid" id="kt_post">
            <!--begin::Container-->
            <div class="container">
                <!--begin::Row-->

                <div class="row g-xl-8">

                    <?php if($menuButtons): ?>
                    <div 
                        class="cursor-pointer col-xl-3 col-md-6 mb-4 border-l-2 border-info shadow h-70 py-2 transition duration-150 ease-in-out transform hover:scale-110 bg-emerald-600 text-white font-semibold py-3 px-6 rounded-md">
                        <a href="#pendingorders">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-md font-weight-bold text-info text-uppercase mb-1">
                                        Pending Orders</div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">
                                        <?php echo e(count($pending_orders)); ?></div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-pause fa-2x text-info"></i>
                                </div>
                            </div>
                        </div>
                        </a>
                    </div>

                    <div wire:click='cancelled'
                        class=" cursor-pointer col-xl-3 col-md-6 mb-4 border-l-2 border-danger shadow h-70 py-2 transition duration-150 ease-in-out transform hover:scale-110 bg-emerald-600 text-white font-semibold py-3 px-6 rounded-md">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-md font-weight-bold text-primary text-uppercase mb-1">
                                        Cancelled Orders</div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">
                                        <?php $counter=0; ?>
                                        <?php $__currentLoopData = $others; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $other): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($other->status == 'Cancelled'): ?>
                                        <?php $counter++; ?>
                                        <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php echo e($counter); ?>

                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-ban fa-2x text-danger"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div wire:click='progress'
                        class="cursor-pointer col-xl-3 col-md-6 mb-4 border-l-2 border-success shadow h-70 py-2 transition duration-150 ease-in-out transform hover:scale-110 bg-emerald-600 text-white font-semibold py-3 px-6 rounded-md">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-md font-weight-bold text-primary text-uppercase mb-1">
                                        Orders In Progress</div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">
                                        <?php $counter=0; ?>
                                        <?php $__currentLoopData = $others; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $other): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($other->status == 'In progress'): ?>
                                        <?php $counter++; ?>
                                        <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php echo e($counter); ?>

                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-tasks fa-2x text-primary"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div wire:click='completed'
                        class="cursor-pointer col-xl-3 col-md-6 mb-4 border-l-2 border-success shadow h-70 py-2 transition duration-150 ease-in-out transform hover:scale-110 bg-emerald-600 text-white font-semibold py-3 px-6 rounded-md">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-md font-weight-bold text-primary text-uppercase mb-1">
                                        Completed Orders</div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">
                                        <?php $counter=0; ?>
                                        <?php $__currentLoopData = $others; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $other): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($other->status == 'Complete'): ?>
                                        <?php $counter++; ?>
                                        <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php echo e($counter); ?>

                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-check fa-2x text-primary"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div wire:click='revisions'
                        class="cursor-pointer col-xl-3 col-md-6 mb-4 border-l-2 border-info shadow h-70 py-2 transition duration-150 ease-in-out transform hover:scale-110 bg-emerald-600 text-white font-semibold py-3 px-6 rounded-md">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-md font-weight-bold text-primary text-uppercase mb-1">
                                        Revisions</div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">
                                        <?php $counter=0; ?>
                                        <?php $__currentLoopData = $revisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $revision): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($revision->status == 'Pending'): ?>
                                        <?php $counter++; ?>
                                        <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php echo e($counter); ?>

                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-tasks fa-2x text-info"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div wire:click='ongoingRevisions'
                        class="cursor-pointer col-xl-3 col-md-6 mb-4 border-l-2 border-info shadow h-70 py-2 transition duration-150 ease-in-out transform hover:scale-110 bg-emerald-600 text-white font-semibold py-3 px-6 rounded-md">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-md font-weight-bold text-primary text-uppercase mb-1">
                                        Revisions In Progress</div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">
                                        <?php $counter=0; ?>
                                        <?php $__currentLoopData = $revisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $revision): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($revision->status == 'In Progress'): ?>
                                        <?php $counter++; ?>
                                        <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php echo e($counter); ?>

                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-tasks fa-2x text-info"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div wire:click='doneRevisions'
                        class="cursor-pointer col-xl-3 col-md-6 mb-4 border-l-2 border-success shadow h-70 py-2 transition duration-150 ease-in-out transform hover:scale-110 bg-emerald-600 text-white font-semibold py-3 px-6 rounded-md">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-md font-weight-bold text-primary text-uppercase mb-1">
                                        Completed Revisions</div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">
                                        <?php $counter=0; ?>
                                        <?php $__currentLoopData = $revisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $revision): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($revision->status == 'Complete'): ?>
                                        <?php $counter++; ?>
                                        <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php echo e($counter); ?>

                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-check-double fa-2x text-primary"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>


                        <!--begin::Col-->
                        <div class="col-xxl-12">
                            <?php if($quickStats): ?>

                            <div class="quick-stats row g-xl-8">
                                <!--begin::Col-->
                                <div class="col-xl-4">
                                        <!--begin::Engage Widget 1-->
                                    <div class="card card-xxl-stretch mb-5 mb-xl-8">
                                        <!--begin::Body-->
                                        <div class="card-body p-0">
                                            <!--begin::Header-->
                                            <div class="px-9 pt-6 card-rounded h-250px w-100 bgi-no-repeat bgi-size-cover bgi-position-y-top h-200px"
                                                style="background-image: url(<?php echo e(asset('dash-assets/img/bg-green.png')); ?>)">
                                                <!--begin::Heading-->
                                                <div class="d-flex flex-stack">
                                                    <h3 class="m-0 text-white fw-bolder fs-3">
                                                        Quick Stats
                                                    </h3>
                                                </div>
                                                <!--end::Heading-->
                                                <!--begin::Balance-->
                                                <div class="fw-bolder fs-7 text-center text-white pt-5">
                                                    You Balance
                                                    <span class="fw-boldest fs-2hx d-block mt-n1">$00.00</span>
                                                </div>
                                                <!--end::Balance-->
                                            </div>
                                            <!--end::Header-->
                                            <!--begin::Items-->

                                            <div class="shadow-xs card-rounded mx-9 mb-9 px-6 py-9 position-relative z-index-1 bg-white"
                                                style="margin-top: -100px">
                                                <!--begin::Item-->
                                                <div class="d-flex align-items-center mb-">
                                                    <div class="card border-l-2 border-info shadow h-70 py-2">
                                                        <div class="card-body">
                                                            <div class="row no-gutters align-items-center">
                                                                <div class="col mr-2">
                                                                    <div class="text-md font-weight-bold text-info text-uppercase mb-1">
                                                                        <?php echo e(\Carbon\Carbon::now()->toDateString()); ?> </div>
                                                                    <div class="h5 mb-0 font-weight-bold text-gray-800"></div>
                                                                </div>
                                                                <div class="col-auto">
                                                                    <i class="fas fa-clock fa-2x text-info"></i>
                                                                </div>
                                                                <a href="<?php echo e(route('create-order')); ?>">
                                                                    <button
                                                                        class=" btn-primary transition duration-150 ease-in-out transform hover:scale-110 bg-emerald-600 text-white font-semibold py-3 px-6 rounded-md">
                                                                        Create New Order
                                                                    </button>
                                                                </a>

                                                                <br>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>


                                            <!--end::Items-->
                                        </div>
                                        <!--end::Body-->
                                    </div>
                                <!--end::Engage Widget 1-->
                                </div>

                                <!--begin::Col-->
                                <div class="col-xl-4">
                                    <!--begin::Slider Widget 1-->
                                    <div class="card card-xl-stretch mb-5 mb-xl-8">
                                        <!--begin::Body-->
                                        <div class="card-body pt-5">
                                            <div id="kt_stats_widget_8_carousel"
                                                class="carousel carousel-custom carousel-stretch slide"
                                                data-bs-ride="carousel" data-bs-interval="8000">
                                                <!--begin::Heading-->
                                                <div class="d-flex flex-stack flex-wrap">
                                                    <span class="fs-4 text-gray-400 fw-boldest pe-2">Current Jobs</span>
                                                    <!--begin::Carousel Indicators-->
                                                    <ol class="p-0 m-0 carousel-indicators carousel-indicators-dots">
                                                        <?php $x=0; ?>
                                                        <?php $__currentLoopData = $ongoing; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $ongoing_order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li data-bs-target="#kt_stats_widget_8_carousel"
                                                            data-bs-slide-to="<?php echo e($x); ?>"
                                                            class="<?php echo e($x == 0? 'ms-1 active' : 'ms-1'); ?>"></li>
                                                        <?php $x++; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ol>
                                                    <!--end::Carousel Indicators-->
                                                </div>
                                                <!--end::Heading-->
                                                <!--begin::Carousel-->
                                                <div class="carousel-inner pt-6">
                                                    <!--begin::Item-->
                                                    <?php $x=0; ?>
                                                    <?php $__currentLoopData = $ongoing; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $ongoing_order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class=" <?php echo e($x == 0? 'carousel-item active' : 'carousel-item'); ?>">
                                                        <div class="carousel-wrapper">
                                                            <div
                                                                class="d-flex flex-column justify-content-between flex-grow-1">
                                                                <a href=""
                                                                    class="fs-2 text-gray-800 text-hover-primary fw-boldest"><?php echo e($ongoing_order->topic); ?></a>
                                                                <a href=""
                                                                    class="fs-2 text-gray-600 text-hover-primary fw-bold"><?php echo e($ongoing_order->category->subject); ?></a>
                                                                <p class="text-gray-600 fs-6 fw-bold pt-4 mb-0">
                                                                    <?php echo e(strlen($ongoing_order->instructions) > 50? substr($ongoing_order->instructions,0,50).'...':$ongoing_order->instructions); ?>


                                                                </p>
                                                            </div>
                                                            <!--begin::Info-->
                                                            <div class="d-flex flex-stack pt-8">
                                                                <?php
                                                                $startTime =
                                                                \Carbon\Carbon::parse($ongoing_order->deadline_date);
                                                                // $startTime = $ongoing_order->deadline_date
                                                                $ongoing_order->deadline_time ;
                                                                // {{ \Carbon\Carbon::now()->toDateString() }}
                                                                // $now = ;
                                                                $endTime = \Carbon\Carbon::now()->toDateString();

                                                                $totalDuration =
                                                                $startTime->diff($endTime)->format('%H:%I:%S'). " Time left"
                                                                // $totalDuration = $endTime->diffForHumans($startTime);
                                                                // dd($totalDuration);
                                                                ?>
                                                                <?php if($totalDuration == 0): ?>
                                                                <span
                                                                    class="badge badge-light-danger fs-7 fw-boldest me-2"><?php echo e($totalDuration); ?></span>
                                                                <?php elseif($totalDuration > 1): ?>
                                                                <span
                                                                    class="badge badge-light-primary fs-7 fw-boldest me-2"><?php echo e($totalDuration); ?></span>
                                                                <?php endif; ?>

                                                            </div>
                                                            <!--end::Info-->
                                                        </div>
                                                    </div>
                                                    <?php $x++; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </div>
                                                <!--end::Carousel-->
                                            </div>
                                        </div>
                                        <!--end::Body-->
                                    </div>
                                    <!--end::Slider Widget 1-->
                                </div>
                                <!--end::Col-->
                                <div class="col-xl-4">
                                    <!--begin::Chart Widget 1-->
                                    <div class="card card-xl-stretch mb-5 mb-xl-8">
                                        <!--begin::Body-->
                                        <div class="card-body p-0 d-flex justify-content-between flex-column">
                                            <div class="d-flex flex-stack card-p flex-grow-1">
                                                <!--begin::Icon-->
                                                <div class="symbol symbol-45px">
                                                    <div class="symbol-label">
                                                        <!--begin::Svg Icon | path: icons/stockholm/Shopping/Cart4.svg-->
                                                        <span class="svg-icon svg-icon-2x">
                                                            <i class="bi bi-basket2"></i>
                                                        </span>
                                                        <!--end::Svg Icon-->
                                                    </div>
                                                </div>
                                                <!--end::Icon-->
                                                <!--begin::Text-->
                                                <div class="d-flex flex-column text-end">
                                                    <span class="fw-boldest text-gray-800 fs-2">Essay
                                                        Orders</span>
                                                    <span class="text-gray-400 fw-bold fs-6">April 1 - May
                                                        5</span>
                                                </div>
                                                <!--end::Text-->
                                            </div>
                                            <!--begin::Chart-->
                                            <div class="pt-1">
                                                <div id="kt_chart_widget_1_chart" class="card-rounded-bottom h-125px"></div>
                                            </div>
                                            <!--end::Chart-->
                                        </div>
                                    </div>
                                    <!--end::Chart Widget 1-->
                                </div>
                                <!--end::Col-->

                            </div>

                            <?php endif; ?>

                            <!--begin::Row-->
                            <?php if($centerView != ''): ?>
                            <button wire:click='default'
                                class="btn-primary transition duration-150 ease-in-out transform hover:scale-110 bg-emerald-600 text-white font-semibold py-3 px-6 rounded-md">
                                <span class="svg-icon svg-icon-2 rotate-180">
                                    <i class="bi bi-arrow-bar-left"></i>
                                </span>
                                Back
                            </button>
                            <?php endif; ?>

                            <br class="py-3">
                            <div class="g-xl-8 pt-3">
                                <?php if($centerView == ''): ?>
                                <!--begin::Row-->
                                <div id="pendingorders" class="row g-5 gx-xxl-8 mb-xxl-3">
                                    <!--begin::Col-->
                                    <div class="col-xxl-12">
                                        <!--begin::Table widget 1-->
                                        <div class="card card-xxl-stretch mb-5 mb-xl-3">
                                            <!--begin::Header-->
                                            <div class="card-header border-0 pt-5 pb-3">
                                                <!--begin::Heading-->
                                                <h3 class="card-title align-items-start flex-column">
                                                    <span class="card-label fw-boldest text-gray-800 fs-2">Pending
                                                        Orders</span>

                                                    <span class="text-gray-400 fw-bold mt-2 fs-6">
                                                        <?php echo e(count($pending_orders)); ?> Pending Orders
                                                    </span>

                                                </h3>
                                                <!--end::Heading-->
                                                <!--begin::Toolbar-->
                                                <div class="card-toolbar">
                                                    <!--begin::Search-->
                                                    <div class="w-125px position-relative my-1">
                                                        <!--begin::Svg Icon | path: icons/stockholm/General/Search.svg-->
                                                        <span
                                                            class="svg-icon svg-icon-3 svg-icon-gray-500 position-absolute top-50 translate-middle ms-6">
                                                            <i class="bi bi-search"></i>
                                                        </span>
                                                        <!--end::Svg Icon-->
                                                        <input type="text"
                                                            class="form-control form-control-sm form-control-solid ps-10"
                                                            name="search" value="" placeholder="Search" />
                                                    </div>
                                                    <!--end::Search-->
                                                </div>
                                                <!--end::Toolbar-->
                                            </div>
                                            <!--end::Header-->
                                            <!--begin::Body-->
                                            <div class="card-body py-0">
                                                <!--begin::Table-->
                                                <div class="table-responsive">
                                                    <table
                                                        class="table align-middle table-row-bordered table-row-dashed gy-5"
                                                        id="kt_table_widget_1" x-data=''>
                                                        <thead
                                                            class="border-bottom border-gray-200 fs-5 fw-bold bg-light bg-opacity-75">
                                                            <tr>
                                                                <th class="w-20px ps-0">
                                                                    <div
                                                                        class="form-check form-check-sm form-check-custom form-check-solid me-5">
                                                                        <input class="form-check-input" type="checkbox"
                                                                            data-kt-check="true"
                                                                            data-kt-check-target="#kt_table_widget_1 .form-check-input"
                                                                            value="1" />
                                                                    </div>
                                                                </th>
                                                                <?php $__currentLoopData = $cols; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $col): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if($col['isList'] == true): ?>
                                                                <th class=""><?php echo e($col['colCaption']); ?></th>
                                                                <?php endif; ?>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                <th class="text-end pe-2 min-w-70px">Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php if(count($pending_orders) > 0): ?>
                                                            <?php $__currentLoopData = $pending_orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $pending_order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>

                                                                <td class="p-0">
                                                                    <div
                                                                        class="form-check form-check-sm form-check-custom form-check-solid">
                                                                        <input class="form-check-input" type="checkbox"
                                                                            value="1"
                                                                            x-on:click="$wire.select('<?php echo e($pending_order[$keyCol]); ?>')"
                                                                            <?php echo e($isSelectAll? 'checked':''); ?> />
                                                                    </div>
                                                                </td>
                                                                <?php $__currentLoopData = $cols; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $col): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if($col['isList'] == true): ?>
                                                                <?php if(isset($col['isKey'])): ?>
                                                                <td class="p-0"
                                                                    x-on:click="$wire.view('<?php echo e($pending_order[$keyCol]); ?>')">
                                                                    <div class="d-flex align-items-center">
                                                                        <div class="ps-3">
                                                                            <a href="#"
                                                                                class="text-gray-400 mb-1"><?php echo e($pending_order[$col['colName']]); ?>

                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <?php else: ?>
                                                                <?php if($col['type'] == 'date'): ?>
                                                                <td class="p-0">
                                                                    <div class="d-flex align-items-center">
                                                                        <div class="ps-3">
                                                                            <a href="#"
                                                                                class="text-gray-500  fs-5  mb-1"><?php echo htmlspecialchars_decode(date('j<\s\up>S
                                                                                </\s\up> F Y',
                                                                                strtotime($pending_order[$col['colName']]))); ?>

                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <?php elseif(isset($col['isRelationship']) &&
                                                                $col['isRelationship'] == true): ?>
                                                                <td class="p-0">
                                                                    <div class="d-flex align-items-center">
                                                                        <div class="ps-3">
                                                                            <a href="#" class="text-gray-400 mb-1">
                                                                                <?php echo e($pending_order[$col['relName']][$col['colName']]); ?>

                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <?php elseif($col['colName'] == 'status'): ?>
                                                                <td>
                                                                    <div class="d-flex flex-column w-100 me-2 mt-2 ">
                                                                        <span
                                                                            class="text-red-400 me-2 fw-boldest mb-2 text-danger"><?php echo e($pending_order[$col['colName']]); ?></span>
                                                                    </div>
                                                                </td>
                                                                <?php else: ?>
                                                                <td class="p-0">
                                                                    <div class="d-flex align-items-center">
                                                                        <div class="ps-3">
                                                                            <a href="#" class="text-gray-400 mb-1">
                                                                                <?php echo e($pending_order[$col['colName']]); ?>

                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <?php endif; ?>
                                                                <?php endif; ?>
                                                                <?php endif; ?>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                                <td class="pe-0 text-end">
                                                                    <a class="btn btn-light text-muted fw-boldest text-hover-primary btn-sm px-5"
                                                                        x-on:click="$wire.chat('<?php echo e($pending_order[$keyCol]); ?>')">View</a>
                                                                </td>
                                                            </tr>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php else: ?>
                                                            <tr>
                                                                <td class="italic text-center" colspan="<?php echo e(count($cols)); ?>">
                                                                    <br>*** No records
                                                                    found ***</td>
                                                            </tr>
                                                            <?php endif; ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                                <!--end::Table-->
                                            </div>
                                            <!--end::Body-->
                                        </div>
                                        <!--end::Table widget 1-->
                                        <?php echo e($pending_orders->links('components.pagination-links')); ?>

                                    </div>
                                    <!--end::Col-->
                                </div>
                                <!--end::Row-->
                                <!--begin::Row-->

                                <div id="ongoinorders" class="row g-5 gx-xxl-8 mb-xxl-3">
                                    <!--begin::Col-->
                                    <div class="col-xxl-12">
                                        <!--begin::Table widget 1-->
                                        <div class="card card-xxl-stretch mb-5 mb-xl-3">
                                            <!--begin::Header-->
                                            <div class="card-header border-0 pt-5 pb-3">
                                                <!--begin::Heading-->
                                                <h3 class="card-title align-items-start flex-column">
                                                    <span class="card-label fw-boldest text-gray-800 fs-2">Orders</span>
                                                    <span class="text-gray-400 fw-bold mt-2 fs-6"><?php echo e(count($others)); ?>

                                                        Order(s)</span>
                                                </h3>
                                                <!--end::Heading-->
                                                <!--begin::Toolbar-->
                                                <div class="card-toolbar">
                                                    <!--begin::Select-->
                                                    <div class="pe-6 my-1">
                                                        <select class="form-select form-select-sm form-select-solid w-125px"
                                                            data-control="select2" data-placeholder="All Users"
                                                            data-hide-search="true">
                                                            <option value="1" selected="selected">
                                                                All Orders
                                                            </option>
                                                            <option value="2">Completed</option>
                                                            <option value="3">In Progress</option>
                                                        </select>
                                                    </div>
                                                    <!--end::Select-->
                                                    <!--begin::Search-->
                                                    <div class="w-125px position-relative my-1">
                                                        <!--begin::Svg Icon | path: icons/stockholm/General/Search.svg-->
                                                        <span
                                                            class="svg-icon svg-icon-3 svg-icon-gray-500 position-absolute top-50 translate-middle ms-6">
                                                            <i class="bi bi-search"></i>
                                                        </span>
                                                        <!--end::Svg Icon-->
                                                        <input type="text"
                                                            class="form-control form-control-sm form-control-solid ps-10"
                                                            name="search" value="" placeholder="Search" />
                                                    </div>
                                                    <!--end::Search-->
                                                </div>
                                                <!--end::Toolbar-->
                                            </div>
                                            <!--end::Header-->
                                            <!--begin::Body-->
                                            <div class="card-body py-0">
                                                <!--begin::Table-->
                                                <div class="table-responsive">
                                                    <table
                                                        class="table align-middle table-row-bordered table-row-dashed gy-5"
                                                        id="kt_table_widget_1" x-data=''>
                                                        <thead
                                                            class="border-bottom border-gray-200 fs-5 fw-bold bg-light bg-opacity-75">
                                                            <tr>
                                                                <th class="w-20px ps-0">
                                                                    <div
                                                                        class="form-check form-check-sm form-check-custom form-check-solid me-5">
                                                                        <input class="form-check-input" type="checkbox"
                                                                            data-kt-check="true"
                                                                            data-kt-check-target="#kt_table_widget_1 .form-check-input"
                                                                            value="1" />
                                                                    </div>
                                                                </th>
                                                                <th class="min-w-125px">Date</th>
                                                                <th class="min-w-180px">Order ID</th>
                                                                <th class="min-w-125px">Details</th>
                                                                <th class="min-w-120px">Progress</th>
                                                                <th class="text-end pe-2 min-w-70px">Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php $__currentLoopData = $others; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $other): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <td class="p-0">
                                                                    <div
                                                                        class="form-check form-check-sm form-check-custom form-check-solid">
                                                                        <input class="form-check-input" type="checkbox"
                                                                            value="1" />
                                                                    </div>
                                                                </td>
                                                                <td class="p-0">
                                                                    <div class="d-flex align-items-center">
                                                                        <div class="ps-3">
                                                                            <a href="#"
                                                                                class="text-gray-500  fs-5  mb-1"><?php echo htmlspecialchars_decode(date('j<\s\up>S
                                                                                </\s\up> F Y',
                                                                                strtotime($other->created_at))); ?>

                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td class="p-0">
                                                                    <div class="d-flex align-items-center">
                                                                        <div class="ps-3">
                                                                            <a href="#"
                                                                                class="text-gray-400 mb-1"><?php echo e($other->order_no); ?>

                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td class="p-0">
                                                                    <div class="d-flex align-items-center">
                                                                        <div class="ps-3">
                                                                            <a href="#"
                                                                                class="text-gray-400 mb-1"><?php echo e($other->topic); ?>

                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                    
                                                                </td>
                                                                <td>
                                                                    <div class="d-flex flex-column w-100 me-2 mt-2">

                                                                        <?php if($other->status=='In progress'): ?>
                                                                        <span
                                                                            wire:class="text-gray-400 me-2 fw-boldest mb-2">85%</span>
                                                                        <div class="progress bg-light-info w-100 h-5px">
                                                                            <div class="progress-bar bg-info"
                                                                                role="progressbar" style="width: 85%"></div>
                                                                        </div>
                                                                        <?php elseif($other->status=='Complete'): ?>
                                                                        <span
                                                                            class="text-gray-400 me-2 fw-boldest mb-2">100%</span>
                                                                        <div class="progress bg-light-primary w-100 h-5px">
                                                                            <div class="progress-bar bg-primary"
                                                                                role="progressbar" style="width: 100%">
                                                                            </div>
                                                                        </div>
                                                                        <?php endif; ?>
                                                                    </div>
                                                                </td>
                                                                <td class="pe-0 text-end">
                                                                    <a class="btn btn-light text-muted fw-boldest text-hover-primary btn-sm px-5"
                                                                        x-on:click="$wire.chat('<?php echo e($other->order_no); ?>')">View</a>
                                                                </td>
                                                            </tr>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                                <!--end::Table-->
                                            </div>
                                            <!--end::Body-->
                                        </div>
                                        <!--end::Table widget 1-->
                                        <?php echo e($others->links('components.pagination-links')); ?>

                                    </div>
                                    <!--end::Col-->
                                </div>
                                <!--end::Row-->
                                <?php elseif($centerView=='revisions'): ?>
                                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('client.components.center-view')->html();
} elseif ($_instance->childHasBeenRendered('rdQI7xn')) {
    $componentId = $_instance->getRenderedChildComponentId('rdQI7xn');
    $componentTag = $_instance->getRenderedChildComponentTagName('rdQI7xn');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('rdQI7xn');
} else {
    $response = \Livewire\Livewire::mount('client.components.center-view');
    $html = $response->html();
    $_instance->logRenderedChild('rdQI7xn', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                                <?php elseif($centerView=='pending'): ?>
                                <div class="row g-5 gx-xxl-8 mb-xxl-3">
                                    <!--begin::Col-->
                                    <div class="col-xxl-12">
                                        <!--begin::Table widget 1-->
                                        <div class="card card-xxl-stretch mb-5 mb-xl-3">
                                            <!--begin::Header-->
                                            <div class="card-header border-0 pt-5 pb-3">
                                                <!--begin::Heading-->
                                                <h3 class="card-title align-items-start flex-column">
                                                    <span class="card-label fw-boldest text-gray-800 fs-2">Pending
                                                        Orders</span>

                                                    <span class="text-gray-400 fw-bold mt-2 fs-6">
                                                        <?php echo e(count($pending_orders)); ?> Pending Order(s)
                                                    </span>

                                                </h3>
                                                <!--end::Heading-->
                                                <!--begin::Toolbar-->
                                                <div class="card-toolbar">
                                                    <!--begin::Search-->
                                                    <div class="w-125px position-relative my-1">
                                                        <!--begin::Svg Icon | path: icons/stockholm/General/Search.svg-->
                                                        <span
                                                            class="svg-icon svg-icon-3 svg-icon-gray-500 position-absolute top-50 translate-middle ms-6">
                                                            <i class="bi bi-search"></i>
                                                        </span>
                                                        <!--end::Svg Icon-->
                                                        <input type="text"
                                                            class="form-control form-control-sm form-control-solid ps-10"
                                                            name="search" value="" placeholder="Search" />
                                                    </div>
                                                    <!--end::Search-->
                                                </div>
                                                <!--end::Toolbar-->
                                            </div>
                                            <!--end::Header-->
                                            <!--begin::Body-->
                                            <div class="card-body py-0">
                                                <!--begin::Table-->
                                                <div class="table-responsive">
                                                    <table
                                                        class="table align-middle table-row-bordered table-row-dashed gy-5"
                                                        id="kt_table_widget_1" x-data=''>
                                                        <thead
                                                            class="border-bottom border-gray-200 fs-5 fw-bold bg-light bg-opacity-75">
                                                            <tr>
                                                                <th class="w-20px ps-0">
                                                                    <div
                                                                        class="form-check form-check-sm form-check-custom form-check-solid me-5">
                                                                        <input class="form-check-input" type="checkbox"
                                                                            data-kt-check="true"
                                                                            data-kt-check-target="#kt_table_widget_1 .form-check-input"
                                                                            value="1" />
                                                                    </div>
                                                                </th>
                                                                <?php $__currentLoopData = $cols; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $col): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if($col['isList'] == true): ?>
                                                                <th class=""><?php echo e($col['colCaption']); ?></th>
                                                                <?php endif; ?>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                <th class="text-end pe-2 min-w-70px">Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php if(count($pending_orders) > 0): ?>
                                                            <?php $__currentLoopData = $pending_orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $pending_order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>

                                                                <td class="p-0">
                                                                    <div
                                                                        class="form-check form-check-sm form-check-custom form-check-solid">
                                                                        <input class="form-check-input" type="checkbox"
                                                                            value="1"
                                                                            x-on:click="$wire.select('<?php echo e($pending_order[$keyCol]); ?>')"
                                                                            <?php echo e($isSelectAll? 'checked':''); ?> />
                                                                    </div>
                                                                </td>
                                                                <?php $__currentLoopData = $cols; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $col): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if($col['isList'] == true): ?>
                                                                <?php if(isset($col['isKey'])): ?>
                                                                <td class="p-0"
                                                                    x-on:click="$wire.view('<?php echo e($pending_order[$keyCol]); ?>')">
                                                                    <div class="d-flex align-items-center">
                                                                        <div class="ps-3">
                                                                            <a href="#"
                                                                                class="text-gray-400 mb-1"><?php echo e($pending_order[$col['colName']]); ?>

                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <?php else: ?>
                                                                <?php if($col['type'] == 'date'): ?>
                                                                <td class="p-0">
                                                                    <div class="d-flex align-items-center">
                                                                        <div class="ps-3">
                                                                            <a href="#"
                                                                                class="text-gray-500  fs-5  mb-1"><?php echo htmlspecialchars_decode(date('j<\s\up>S
                                                                                </\s\up> F Y',
                                                                                strtotime($pending_order[$col['colName']]))); ?>

                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <?php elseif(isset($col['isRelationship']) &&
                                                                $col['isRelationship'] == true): ?>
                                                                <td class="p-0">
                                                                    <div class="d-flex align-items-center">
                                                                        <div class="ps-3">
                                                                            <a href="#" class="text-gray-400 mb-1">
                                                                                <?php echo e($pending_order[$col['relName']][$col['colName']]); ?>

                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <?php elseif($col['colName'] == 'status'): ?>
                                                                <td>
                                                                    <div class="d-flex flex-column w-100 me-2 mt-2 ">
                                                                        <span
                                                                            class="text-red-400 me-2 fw-boldest mb-2 text-danger"><?php echo e($pending_order[$col['colName']]); ?></span>
                                                                    </div>
                                                                </td>
                                                                <?php else: ?>
                                                                <td class="p-0">
                                                                    <div class="d-flex align-items-center">
                                                                        <div class="ps-3">
                                                                            <a href="#" class="text-gray-400 mb-1">
                                                                                <?php echo e($pending_order[$col['colName']]); ?>

                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <?php endif; ?>
                                                                <?php endif; ?>
                                                                <?php endif; ?>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                                <td class="pe-0 text-end">
                                                                    <a class="btn btn-light text-muted fw-boldest text-hover-primary btn-sm px-5"
                                                                        x-on:click="$wire.chat('<?php echo e($pending_order[$keyCol]); ?>')">View</a>
                                                                </td>
                                                            </tr>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php else: ?>
                                                            <tr>
                                                                <td class="italic text-center" colspan="<?php echo e(count($cols)); ?>">
                                                                    <br>*** No records
                                                                    found ***</td>
                                                            </tr>
                                                            <?php endif; ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                                <!--end::Table-->
                                            </div>
                                            <!--end::Body-->
                                        </div>
                                        <!--end::Table widget 1-->
                                    </div>
                                    <!--end::Col-->
                                </div>
                                <?php elseif($centerView=='cancelled'): ?>
                                <div class="row g-5 gx-xxl-8 mb-xxl-3">
                                    <!--begin::Col-->
                                    <div class="col-xxl-12">
                                        <!--begin::Table widget 1-->
                                        <div class="card card-xxl-stretch mb-5 mb-xl-3">
                                            <!--begin::Header-->
                                            <div class="card-header border-0 pt-5 pb-3">
                                                <!--begin::Heading-->
                                                <h3 class="card-title align-items-start flex-column">
                                                    <span class="card-label fw-boldest text-gray-800 fs-2">Cancelled
                                                        Orders</span>
                                                    <span class="text-gray-400 fw-bold mt-2 fs-6"><?php echo e(count($cancelled)); ?>

                                                        Order(s)</span>
                                                </h3>
                                                <!--end::Heading-->
                                                <!--begin::Toolbar-->
                                                <div class="card-toolbar">
                                                    <!--begin::Search-->
                                                    <div class="w-125px position-relative my-1">
                                                        <!--begin::Svg Icon | path: icons/stockholm/General/Search.svg-->
                                                        <span
                                                            class="svg-icon svg-icon-3 svg-icon-gray-500 position-absolute top-50 translate-middle ms-6">
                                                            <i class="bi bi-search"></i>
                                                        </span>
                                                        <!--end::Svg Icon-->
                                                        <input type="text"
                                                            class="form-control form-control-sm form-control-solid ps-10"
                                                            name="search" value="" placeholder="Search" />
                                                    </div>
                                                    <!--end::Search-->
                                                </div>
                                                <!--end::Toolbar-->
                                            </div>
                                            <!--end::Header-->
                                            <!--begin::Body-->
                                            <div class="card-body py-0">
                                                <!--begin::Table-->
                                                <div class="table-responsive">
                                                    <table
                                                        class="table align-middle table-row-bordered table-row-dashed gy-5"
                                                        id="kt_table_widget_1" x-data=''>
                                                        <thead
                                                            class="border-bottom border-gray-200 fs-5 fw-bold bg-light bg-opacity-75">
                                                            <tr>
                                                                <th class="w-20px ps-0">
                                                                    <div
                                                                        class="form-check form-check-sm form-check-custom form-check-solid me-5">
                                                                        <input class="form-check-input" type="checkbox"
                                                                            data-kt-check="true"
                                                                            data-kt-check-target="#kt_table_widget_1 .form-check-input"
                                                                            value="1" />
                                                                    </div>
                                                                </th>
                                                                <th class="min-w-125px">Date</th>
                                                                <th class="min-w-180px">Order ID</th>
                                                                <th class="min-w-125px">Details</th>
                                                                <th class="min-w-120px">Status</th>
                                                                <th class="text-end pe-2 min-w-70px">Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php if(count($cancelled) > 0): ?>
                                                            <?php $__currentLoopData = $cancelled; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cancel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <td class="p-0">
                                                                    <div
                                                                        class="form-check form-check-sm form-check-custom form-check-solid">
                                                                        <input class="form-check-input" type="checkbox"
                                                                            value="1" />
                                                                    </div>
                                                                </td>
                                                                <td class="p-0">
                                                                    <div class="d-flex align-items-center">
                                                                        <div class="ps-3">
                                                                            <a href="#"
                                                                                class="text-gray-500  fs-5  mb-1"><?php echo htmlspecialchars_decode(date('j<\s\up>S
                                                                                </\s\up> F Y',
                                                                                strtotime($cancel->created_at))); ?>

                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td class="p-0">
                                                                    <div class="d-flex align-items-center">
                                                                        <div class="ps-3">
                                                                            <a href="#"
                                                                                class="text-gray-400 mb-1"><?php echo e($cancel->order_no); ?>

                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td class="p-0">
                                                                    <div class="d-flex align-items-center">
                                                                        <div class="ps-3">
                                                                            <a href="#"
                                                                                class="text-gray-400 mb-1"><?php echo e($cancel->topic); ?>

                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                    
                                                                </td>
                                                                <td>
                                                                    <div class="d-flex flex-column w-100 me-2 mt-2 ">
                                                                        <span
                                                                            class="text-red-400 me-2 fw-boldest mb-2 text-danger"><?php echo e($cancel->status); ?></span>
                                                                    </div>
                                                                </td>
                                                                <td class="pe-0 text-end">
                                                                    <a class="btn btn-light text-muted fw-boldest text-hover-primary btn-sm px-5"
                                                                        x-on:click="$wire.chat('<?php echo e($cancel->order_no); ?>')">View</a>
                                                                </td>
                                                            </tr>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php else: ?>

                                                            <tr>

                                                                <td colspan="6" class="pe-0 text-end italic text-center">
                                                                    *** No records
                                                                    found ***
                                                                </td>
                                                            </tr>
                                                            <?php endif; ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                                <!--end::Table-->
                                            </div>
                                            <!--end::Body-->
                                        </div>
                                        <!--end::Table widget 1-->
                                        <?php echo e($cancelled->links('components.pagination-links')); ?>

                                    </div>
                                    <!--end::Col-->
                                </div>
                                <?php elseif($centerView=='In Progress'): ?>
                                <div class="row g-5 gx-xxl-8 mb-xxl-3">
                                    <!--begin::Col-->
                                    <div class="col-xxl-12">
                                        <!--begin::Table widget 1-->
                                        <div class="card card-xxl-stretch mb-5 mb-xl-3">
                                            <!--begin::Header-->
                                            <div class="card-header border-0 pt-5 pb-3">
                                                <!--begin::Heading-->
                                                <h3 class="card-title align-items-start flex-column">
                                                    <span class="card-label fw-boldest text-gray-800 fs-2">Orders In
                                                        Progress</span>
                                                    <span class="text-gray-400 fw-bold mt-2 fs-6"><?php echo e(count($ongoing)); ?>

                                                        Order(s)</span>
                                                </h3>
                                                <!--end::Heading-->
                                                <!--begin::Toolbar-->
                                                <div class="card-toolbar">
                                                    <!--begin::Search-->
                                                    <div class="w-125px position-relative my-1">
                                                        <!--begin::Svg Icon | path: icons/stockholm/General/Search.svg-->
                                                        <span
                                                            class="svg-icon svg-icon-3 svg-icon-gray-500 position-absolute top-50 translate-middle ms-6">
                                                            <i class="bi bi-search"></i>
                                                        </span>
                                                        <!--end::Svg Icon-->
                                                        <input type="text"
                                                            class="form-control form-control-sm form-control-solid ps-10"
                                                            name="search" value="" placeholder="Search" />
                                                    </div>
                                                    <!--end::Search-->
                                                </div>
                                                <!--end::Toolbar-->
                                            </div>
                                            <!--end::Header-->
                                            <!--begin::Body-->
                                            <div class="card-body py-0">
                                                <!--begin::Table-->
                                                <div class="table-responsive">
                                                    <table
                                                        class="table align-middle table-row-bordered table-row-dashed gy-5"
                                                        id="kt_table_widget_1" x-data=''>
                                                        <thead
                                                            class="border-bottom border-gray-200 fs-5 fw-bold bg-light bg-opacity-75">
                                                            <tr>
                                                                <th class="w-20px ps-0">
                                                                    <div
                                                                        class="form-check form-check-sm form-check-custom form-check-solid me-5">
                                                                        <input class="form-check-input" type="checkbox"
                                                                            data-kt-check="true"
                                                                            data-kt-check-target="#kt_table_widget_1 .form-check-input"
                                                                            value="1" />
                                                                    </div>
                                                                </th>
                                                                <th class="min-w-125px">Date</th>
                                                                <th class="min-w-180px">Order ID</th>
                                                                <th class="min-w-125px">Details</th>
                                                                <th class="min-w-120px">Progress</th>
                                                                <th class="text-end pe-2 min-w-70px">Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php if(count($ongoing) > 0): ?>
                                                            <?php $__currentLoopData = $ongoing; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $on): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <td class="p-0">
                                                                    <div
                                                                        class="form-check form-check-sm form-check-custom form-check-solid">
                                                                        <input class="form-check-input" type="checkbox"
                                                                            value="1" />
                                                                    </div>
                                                                </td>
                                                                <td class="p-0">
                                                                    <div class="d-flex align-items-center">
                                                                        <div class="ps-3">
                                                                            <a href="#"
                                                                                class="text-gray-500  fs-5  mb-1"><?php echo htmlspecialchars_decode(date('j<\s\up>S
                                                                                </\s\up> F Y',
                                                                                strtotime($on->created_at))); ?>

                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td class="p-0">
                                                                    <div class="d-flex align-items-center">
                                                                        <div class="ps-3">
                                                                            <a href="#"
                                                                                class="text-gray-400 mb-1"><?php echo e($on->order_no); ?>

                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td class="p-0">
                                                                    <div class="d-flex align-items-center">
                                                                        <div class="ps-3">
                                                                            <a href="#"
                                                                                class="text-gray-400 mb-1"><?php echo e($on->topic); ?>

                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                    
                                                                </td>
                                                                <td>
                                                                    <div class="d-flex flex-column w-100 me-2 mt-2">

                                                                        <?php if($on->status=='In progress'): ?>
                                                                        <span
                                                                            wire:class="text-gray-400 me-2 fw-boldest mb-2">85%</span>
                                                                        <div class="progress bg-light-info w-100 h-5px">
                                                                            <div class="progress-bar bg-info"
                                                                                role="progressbar" style="width: 85%"></div>
                                                                        </div>

                                                                        <?php endif; ?>
                                                                    </div>
                                                                </td>
                                                                <td class="pe-0 text-end">
                                                                    <a class="btn btn-light text-muted fw-boldest text-hover-primary btn-sm px-5"
                                                                        x-on:click="$wire.chat('<?php echo e($on->order_no); ?>')">View</a>
                                                                </td>
                                                            </tr>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php else: ?>
                                                            <tr>
                                                                <td class="pe-0 text-end italic text-center">
                                                                    <br>*** No records
                                                                    found ***</td>
                                                            </tr>
                                                            <?php endif; ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                                <!--end::Table-->
                                            </div>
                                            <!--end::Body-->
                                        </div>
                                        <!--end::Table widget 1-->
                                        <?php echo e($ongoing->links('components.pagination-links')); ?>

                                    </div>
                                    <!--end::Col-->
                                </div>
                                <?php elseif($centerView=='Completed'): ?>
                                <div class="row g-5 gx-xxl-8 mb-xxl-3">
                                    <!--begin::Col-->
                                    <div class="col-xxl-12">
                                        <!--begin::Table widget 1-->
                                        <div class="card card-xxl-stretch mb-5 mb-xl-3">
                                            <!--begin::Header-->
                                            <div class="card-header border-0 pt-5 pb-3">
                                                <!--begin::Heading-->
                                                <h3 class="card-title align-items-start flex-column">
                                                    <span class="card-label fw-boldest text-gray-800 fs-2">Completed
                                                        Orders</span>
                                                    <span class="text-gray-400 fw-bold mt-2 fs-6"><?php echo e(count($complete)); ?>

                                                        Order(s)</span>
                                                </h3>
                                                <!--end::Heading-->
                                                <!--begin::Toolbar-->
                                                <div class="card-toolbar">
                                                    <!--begin::Search-->
                                                    <div class="w-125px position-relative my-1">
                                                        <!--begin::Svg Icon | path: icons/stockholm/General/Search.svg-->
                                                        <span
                                                            class="svg-icon svg-icon-3 svg-icon-gray-500 position-absolute top-50 translate-middle ms-6">
                                                            <i class="bi bi-search"></i>
                                                        </span>
                                                        <!--end::Svg Icon-->
                                                        <input type="text"
                                                            class="form-control form-control-sm form-control-solid ps-10"
                                                            name="search" value="" placeholder="Search" />
                                                    </div>
                                                    <!--end::Search-->
                                                </div>
                                                <!--end::Toolbar-->
                                            </div>
                                            <!--end::Header-->
                                            <!--begin::Body-->
                                            <div class="card-body py-0">
                                                <!--begin::Table-->
                                                <div class="table-responsive">
                                                    <table
                                                        class="table align-middle table-row-bordered table-row-dashed gy-5"
                                                        id="kt_table_widget_1" x-data=''>
                                                        <thead
                                                            class="border-bottom border-gray-200 fs-5 fw-bold bg-light bg-opacity-75">
                                                            <tr>
                                                                <th class="w-20px ps-0">
                                                                    <div
                                                                        class="form-check form-check-sm form-check-custom form-check-solid me-5">
                                                                        <input class="form-check-input" type="checkbox"
                                                                            data-kt-check="true"
                                                                            data-kt-check-target="#kt_table_widget_1 .form-check-input"
                                                                            value="1" />
                                                                    </div>
                                                                </th>
                                                                <th class="min-w-125px">Date</th>
                                                                <th class="min-w-180px">Order ID</th>
                                                                <th class="min-w-125px">Details</th>
                                                                <th class="min-w-120px">Progress</th>
                                                                <th class="text-end pe-2 min-w-70px">Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php if(count($complete) > 0): ?>
                                                            <?php $__currentLoopData = $complete; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $complete): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <td class="p-0">
                                                                    <div
                                                                        class="form-check form-check-sm form-check-custom form-check-solid">
                                                                        <input class="form-check-input" type="checkbox"
                                                                            value="1" />
                                                                    </div>
                                                                </td>
                                                                <td class="p-0">
                                                                    <div class="d-flex align-items-center">
                                                                        <div class="ps-3">
                                                                            <a href="#"
                                                                                class="text-gray-500  fs-5  mb-1"><?php echo htmlspecialchars_decode(date('j<\s\up>S
                                                                                </\s\up> F Y',
                                                                                strtotime($complete->created_at))); ?>

                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td class="p-0">
                                                                    <div class="d-flex align-items-center">
                                                                        <div class="ps-3">
                                                                            <a href="#"
                                                                                class="text-gray-400 mb-1"><?php echo e($complete->order_no); ?>

                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td class="p-0">
                                                                    <div class="d-flex align-items-center">
                                                                        <div class="ps-3">
                                                                            <a href="#"
                                                                                class="text-gray-400 mb-1"><?php echo e($complete->topic); ?>

                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                    
                                                                </td>
                                                                <td>
                                                                    <div class="d-flex flex-column w-100 me-2 mt-2">

                                                                        <?php if($complete->status=='Complete'): ?>
                                                                        <span
                                                                            wire:class="text-gray-400 me-2 fw-boldest mb-2">100%</span>
                                                                        <div class="progress bg-light-info w-100 h-5px">
                                                                            <div class="progress-bar bg-success"
                                                                                role="progressbar" style="width: 100%">
                                                                            </div>
                                                                        </div>

                                                                        <?php endif; ?>
                                                                    </div>
                                                                </td>
                                                                <td class="pe-0 text-end">
                                                                    <a class="btn btn-light text-muted fw-boldest text-hover-primary btn-sm px-5"
                                                                        x-on:click="$wire.chat('<?php echo e($complete->order_no); ?>')">View</a>
                                                                </td>
                                                            </tr>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php else: ?>
                                                            <tr>
                                                                <td colspan="6" class="pe-0 text-end italic text-center">
                                                                    *** No records
                                                                    found ***
                                                                </td>
                                                            </tr>
                                                            <?php endif; ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                                <!--end::Table-->
                                            </div>
                                            <!--end::Body-->
                                        </div>
                                        <!--end::Table widget 1-->
                                        <?php echo e($complete->links('components.pagination-links')); ?>

                                    </div>
                                    <!--end::Col-->
                                </div>
                                <?php elseif($centerView=='done revisions'): ?>
                                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('client.components.center-view')->html();
} elseif ($_instance->childHasBeenRendered('jGR38nj')) {
    $componentId = $_instance->getRenderedChildComponentId('jGR38nj');
    $componentTag = $_instance->getRenderedChildComponentTagName('jGR38nj');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('jGR38nj');
} else {
    $response = \Livewire\Livewire::mount('client.components.center-view');
    $html = $response->html();
    $_instance->logRenderedChild('jGR38nj', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                                <?php endif; ?>

                            </div>
                            <!--end::Row-->
                            <!--begin::Row-->
                            <!--end::Row-->
                        </div>
                        <!--end ::Col-->
                </div>
                <!--end::Row-->

            </div>
            <!--end::Container-->
        </div>
        <!--end::Post-->
    </div>
    <?php elseif($varView == 'chat'): ?>
    <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('client.chat-order-summary')->html();
} elseif ($_instance->childHasBeenRendered('KaQ3rxt')) {
    $componentId = $_instance->getRenderedChildComponentId('KaQ3rxt');
    $componentTag = $_instance->getRenderedChildComponentTagName('KaQ3rxt');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('KaQ3rxt');
} else {
    $response = \Livewire\Livewire::mount('client.chat-order-summary');
    $html = $response->html();
    $_instance->logRenderedChild('KaQ3rxt', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
    <?php elseif($varView == 'edit'): ?>
    <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('client.edit-order')->html();
} elseif ($_instance->childHasBeenRendered('hcTcib9')) {
    $componentId = $_instance->getRenderedChildComponentId('hcTcib9');
    $componentTag = $_instance->getRenderedChildComponentTagName('hcTcib9');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('hcTcib9');
} else {
    $response = \Livewire\Livewire::mount('client.edit-order');
    $html = $response->html();
    $_instance->logRenderedChild('hcTcib9', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
    <?php elseif($varView == 'invoice'): ?>
    <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('client.invoice')->html();
} elseif ($_instance->childHasBeenRendered('nLzVY4t')) {
    $componentId = $_instance->getRenderedChildComponentId('nLzVY4t');
    $componentTag = $_instance->getRenderedChildComponentTagName('nLzVY4t');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('nLzVY4t');
} else {
    $response = \Livewire\Livewire::mount('client.invoice');
    $html = $response->html();
    $_instance->logRenderedChild('nLzVY4t', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
    <?php endif; ?>

    

</div>
<style>
    #pendingorders {
        transition-duration: 500ms;
        transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
    }
    .bs-wizard {margin-top: 40px;}

    /*Form Wizard*/
    .bs-wizard {border-bottom: solid 1px #e0e0e0; padding: 0 0 10px 0;}
    .bs-wizard > .bs-wizard-step {padding: 0; position: relative;}
    .bs-wizard > .bs-wizard-step + .bs-wizard-step {}
    .bs-wizard > .bs-wizard-step .bs-wizard-stepnum {color: #595959; font-size: 16px; margin-bottom: 5px;}
    .bs-wizard > .bs-wizard-step .bs-wizard-info {color: #999; font-size: 14px;}
    .bs-wizard > .bs-wizard-step > .bs-wizard-dot {position: absolute; width: 30px; height: 30px; display: block; background: #fbe8aa; top: 45px; left: 50%; margin-top: -15px; margin-left: -15px; border-radius: 50%;}
    .bs-wizard > .bs-wizard-step > .bs-wizard-dot:after {content: ' '; width: 14px; height: 14px; background: #fbbd19; border-radius: 50px; position: absolute; top: 8px; left: 8px; }
    .bs-wizard > .bs-wizard-step > .progress {position: relative; border-radius: 0px; height: 8px; box-shadow: none; margin: 20px 0;}
    .bs-wizard > .bs-wizard-step > .progress > .progress-bar {width:0px; box-shadow: none; background: #fbe8aa;}
    .bs-wizard > .bs-wizard-step.complete > .progress > .progress-bar {width:100%;}
    .bs-wizard > .bs-wizard-step.active > .progress > .progress-bar {width:50%;}
    .bs-wizard > .bs-wizard-step:first-child.active > .progress > .progress-bar {width:0%;}
    .bs-wizard > .bs-wizard-step:last-child.active > .progress > .progress-bar {width: 100%;}
    .bs-wizard > .bs-wizard-step.disabled > .bs-wizard-dot {background-color: #f5f5f5;}
    .bs-wizard > .bs-wizard-step.disabled > .bs-wizard-dot:after {opacity: 0;}
    .bs-wizard > .bs-wizard-step:first-child  > .progress {left: 50%; width: 50%;}
    .bs-wizard > .bs-wizard-step:last-child  > .progress {width: 50%;}
    .bs-wizard > .bs-wizard-step.disabled a.bs-wizard-dot{ pointer-events: none; }
    /*END Form Wizard*/


    /*responsiveness*/
    @media(max-width :768px){
        .quick-stats{
            display: none;
        }
        .menu-btns{
            /* transform: scale(0.7); */
        }
        .test{
            display: visible;
        }
    }
</style>
<?php /**PATH C:\xampp\htdocs\Nariphon_Technologies\typewriter\resources\views/livewire/client/dashboard.blade.php ENDPATH**/ ?>