<div>
     <!-- Custom CSS -->
     <link href="<?php echo e(asset('assets/css/styles.css')); ?>" rel="stylesheet" />
     <link href="<?php echo e(asset('assets/css/custom.css')); ?>" rel="stylesheet" />
    
    <div wire:loading>
        <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('general.loader')->html();
} elseif ($_instance->childHasBeenRendered('D7STOiW')) {
    $componentId = $_instance->getRenderedChildComponentId('D7STOiW');
    $componentTag = $_instance->getRenderedChildComponentTagName('D7STOiW');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('D7STOiW');
} else {
    $response = \Livewire\Livewire::mount('general.loader');
    $html = $response->html();
    $_instance->logRenderedChild('D7STOiW', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
    </div>
    <h3 class="my-4">
        Check your order and add funds to your balance
    </h3>
    <button wire:click='back' class="btn btn-sm btn-primary btn-active-light-text-primary">
       Back
    </button>
    <div class="row">
        <div class="col-12 py-4">
            <p class="muted mb-0 text-primary">Topic</p>
            <p class="lead"><?php echo e($orderDetails->topic); ?></p>

            <div class="d-flex justify-content-around align-item-center">
                <div>
                    <p class="muted text-primary">Subject</p>
                    <p class="lead fw-bold"><?php echo e($orderDetails->category->subject); ?></p>
                </div>
                <div>
                    <p class="muted text-primary">Pages</p>
                    <p class="lead fw-bold"><?php echo e($orderDetails->pages); ?> pages /<?php echo e($orderDetails->pages*275); ?> words</p>
                </div>
                <div>
                    <p class="muted text-primary">Deadline</p>
                    <p class="lead fw-bold"><?php echo date('d/M/y', strtotime($orderDetails->deadline_date)); ?>- <?php echo date('H:i', strtotime($orderDetails->deadline_time)); ?></p>
                </div>
                <div>
                    
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-9 col-md-12 col-sm-12 py-4">
            <h3 class="lead text-primary">Useful Extras</h3>
            <div class="d-flex justify-content-around align-items-center">
                <div>
                    <p class="fw-bold text-primary">100% refund guarantee</p>
                    <p class="small muted">
                        We will refund you the whole amount if you are not
                        happy.
                    </p>
                </div>
                <div>
                    <p class="fw-bold text-primary">Privacy #1</p>
                    <p class="small muted">
                        Your email or name will not appear on the website.
                    </p>
                </div>
                <div>
                    <p class="fw-bold text-primary">Strict level of security</p>
                    <p class="small muted">
                        We use 128-bit SSL protection and high levels of
                        security.
                    </p>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-12 col-sm-12 shadow py-4">
            <h3 class="lead text-primary">Order Summary</h3>
            <p class="muted d-flex justify-content-between align-items-center">
                <span>Paper price</span><span>$<?php echo e($orderDetails->bill->amount); ?></span>
            </p>
            <p class="muted small d-flex justify-content-between align-items-center">
                <span><?php echo e($orderDetails->pages); ?> Pages x $<?php echo e($orderDetails->bill->amount); ?></span><span>$<?php echo e($orderDetails->bill->total_amount); ?></span>
            </p>
            <p class="muted small text-success d-flex justify-content-between align-items-center">
                <span>Tax</span><span>-$0.00</span>
            </p>
            <hr />
            <p class="fw-bold d-flex justify-content-between align-items-center">
                <span>Total Price</span><span>-$<?php echo e($orderDetails->bill->total_amount); ?></span>
            </p>
            <p class="fw-bold d-flex justify-content-between align-items-center">
                <span>Paid Amount</span><span>+$<?php echo e($orderDetails->bill->paid_amount); ?></span>
            </p>
            <hr />
            <p class="fw-bold d-flex justify-content-between align-items-center">
                <span>Balance</span><span>-$<?php echo e($orderDetails->bill->total_amount - $orderDetails->bill->paid_amount); ?></span>
            </p>
            <p class="muted small text-center">
                The funds will be held in your account until you
                release them.
            </p>
            <button wire:click='checkOut' class="btn dark-2 btm-md full-width">
                Checkout
            </button>

            <p class="muted small text-center mt-3">
                The funds will be held in your account until you
                release them.
            </p>
        </div>
    </div>
</div>

<?php /**PATH C:\xampp\htdocs\Nariphon_Technologies\typewriter\resources\views/livewire/order/check-order.blade.php ENDPATH**/ ?>