<div>
    <div>
        <div class="flex justify-between items-center pb-3" x-data="{}">
            <p class="text-2xl font-bold">Give Access</p>
            <div class="cursor-pointer z-50" x-on:click="$dispatch('dlg-modal');">
                <svg class="fill-current text-black" xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                    viewBox="0 0 18 18">
                    <path
                        d="M14.53 4.53l-1.06-1.06L9 7.94 4.53 3.47 3.47 4.53 7.94 9l-4.47 4.47 1.06 1.06L9 10.06l4.47 4.47 1.06-1.06L10.06 9z">
                    </path>
                </svg>
            </div>
        </div>
    </div>
    <?php if(session()->has('success-modal')): ?>
    <div class="m-auto">
        <div class="bg-white rounded-lg border-gray-300 border p-3 shadow-lg">
            <div class="flex flex-row">
                <div class="px-2">
                    <svg width="24" height="24" viewBox="0 0 1792 1792" fill="#44C997"
                        xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M1299 813l-422 422q-19 19-45 19t-45-19l-294-294q-19-19-19-45t19-45l102-102q19-19 45-19t45 19l147 147 275-275q19-19 45-19t45 19l102 102q19 19 19 45t-19 45zm141 83q0-148-73-273t-198-198-273-73-273 73-198 198-73 273 73 273 198 198 273 73 273-73 198-198 73-273zm224 0q0 209-103 385.5t-279.5 279.5-385.5 103-385.5-103-279.5-279.5-103-385.5 103-385.5 279.5-279.5 385.5-103 385.5 103 279.5 279.5 103 385.5z" />
                    </svg>
                </div>
                <div class="">
                    <span class="font-semibold"> <?php echo e(session('success-modal')); ?></span>
                    
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    <?php if(session()->has('error-modal')): ?>
    <div class="m-auto">
        <div class="bg-danger rounded-lg border-gray-300 border p-3 shadow-lg"
            style="background-color: rgba(224,52,18,.1) !important; color: rgba(224,52,18,.5);">
            <div class="flex flex-row">
                <div class="px-2 text-damger">
                    <i class="text-danger fas fa-times-circle fa-2x"></i>
                </div>
                <div class="">
                    <span class="font-semibold text-danger"> <?php echo e(session('error-modal')); ?></span>
                    
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    <div wire:loading wire:target='grantAccess'>
        <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('general.loader-gif')->html();
} elseif ($_instance->childHasBeenRendered('oS7dQYt')) {
    $componentId = $_instance->getRenderedChildComponentId('oS7dQYt');
    $componentTag = $_instance->getRenderedChildComponentTagName('oS7dQYt');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('oS7dQYt');
} else {
    $response = \Livewire\Livewire::mount('general.loader-gif');
    $html = $response->html();
    $_instance->logRenderedChild('oS7dQYt', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
    </div>
    <span class="float-center"><label class="font-bold text-green-700 py-2" for="">Grant Access to Writer</label></span>
    <br>
    <div class="flex justify-start mt-3">
        <label for="" class="font-semibold mr-3 mt-2">Approve/Decline:</label>
        <div class="mb-3 xl:w-96">
            <select wire:model.defer='status' class="form-select appearance-none
            block
            w-full
            px-3
            py-1.5
            text-base
            font-normal
            text-gray-700
            bg-white bg-clip-padding bg-no-repeat
            border border-solid border-gray-300
            rounded
            transition
            ease-in-out
            m-0
            focus:text-gray-700 focus:bg-white focus:border-blue-600  <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>: border-red-600 outline-red-600 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" aria-label="Default select example">
                <option value="Approved" selected>Approve</option>
                <option value="Declined" selected>Decline</option>
            </select>
            <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <div class="block w-full text-red-500"><?php echo e($message); ?></div>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

    </div>
    <div class="flex justify-start mt-3">
        <label for="" class="font-semibold mr-3 mt-2">Set Time Limit (Optional):</label>
        <div class="mb-3 xl:w-96">
            <input wire:model.defer='time_limit' placeholder=""
            class="appearance-none block w-full bg-grey-lighter text-grey-darker border border-grey-lighter rounded-lg h-10 px-4"
            type="time">
        </div>
    </div>
    

    <div class="flex justify-end pt-2">
        <button wire:click="grantAccess"
            class="px-4 bg-transparent p-3 rounded-lg text-indigo-500 hover:bg-gray-100 hover:text-indigo-400 mr-2">Confirm</button>
        <button x-on:click="$dispatch('dlg-modal');" class="modal-close px-4 bg-indigo-500 p-3 rounded-lg text-white hover:bg-indigo-400"
            >Close</button>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/tw-elements/dist/js/index.min.js"></script>
<?php /**PATH C:\xampp\htdocs\Nariphon_Technologies\typewriter\resources\views/livewire/admin/components/give-writer-access-modal.blade.php ENDPATH**/ ?>