import { TomCreateFilter, TomCreate, TomLoadCallback } from './index';
import { escape_html } from '../utils';
export declare type TomSettings = {
    options?: any[];
    optgroups?: any[];
    items: any[];
    plugins: any[];
    delimiter: string;
    splitOn: RegExp | string;
    persist: boolean;
    diacritics: boolean;
    create: boolean | TomCreate;
    createOnBlur: boolean;
    createFilter: RegExp | string | TomCreateFilter;
    highlight: boolean;
    openOnFocus: boolean;
    shouldOpen: boolean;
    maxOptions: number;
    maxItems: null | number;
    hideSelected: boolean;
    duplicates: boolean;
    addPrecedence: boolean;
    selectOnTab: boolean;
    preload: boolean | string;
    allowEmptyOption: boolean;
    closeAfterSelect: boolean;
    loadThrottle: number;
    loadingClass: string;
    dataAttr: string;
    optgroupField: string;
    valueField: string;
    labelField: string;
    disabledField: string;
    optgroupLabelField: string;
    optgroupValueField: string;
    lockOptgroupOrder: boolean;
    sortField: string | any[];
    searchField: string[];
    searchConjunction: string;
    nesting: boolean;
    mode: string;
    wrapperClass: string;
    inputClass: string;
    dropdownClass: string;
    dropdownContentClass: string;
    itemClass: string;
    optionClass: string;
    dropdownParent: string;
    controlInput: HTMLInputElement;
    copyClassesToDropdown: boolean;
    placeholder: string;
    hidePlaceholder: boolean;
    load: (value: string, callback: TomLoadCallback) => void;
    score?: (query: string) => () => any;
    shouldLoad: (query: string) => boolean;
    onInitialize: (evt: Event) => void;
    onChange: (evt: Event) => void;
    onItemAdd: (evt: Event) => void;
    onItemRemove: (evt: Event) => void;
    onClear: (evt: Event) => void;
    onOptionAdd: (evt: Event) => void;
    onOptionRemove: (evt: Event) => void;
    onOptionClear: (evt: Event) => void;
    onOptionGroupAdd: (evt: Event) => void;
    onOptionGroupRemove: (evt: Event) => void;
    onOptionGroupClear: (evt: Event) => void;
    onDropdownOpen: (evt: Event) => void;
    onDropdownClose: (evt: Event) => void;
    onType: (evt: Event) => void;
    onLoad: (evt: Event) => void;
    onFocus: (evt: Event) => void;
    onBlur: (evt: Event) => void;
    onDelete: (values: string[], evt: KeyboardEvent | MouseEvent) => boolean;
    render: {
        [key: string]: (data: any, escape: typeof escape_html) => string | HTMLElement;
    };
    firstUrl: (query: string) => any;
};
