// node x-test.js


var assert = require('assert');
var diacritics = require('./build/cjs/diacritics.js');
var utils = require('./build/cjs/utils.js');
var Sifter = require('./build/cjs/sifter.js');


var str, reg, sifter;


str = '\u0041\u006d\u0065\u0301\u006c\u0069\u0065';
str = 'ae';
str = 'ﬁ';
str = 'أهلا';

var str = 'ſ';
var regex = /(?:s|S|ſ)/i;


const asciifold = (str) => {
	return str.normalize('NFKD');
	return str.normalize('NFD').replace(/[\u0300-\u036F]/g, '').normalize('NFKD').toLowerCase();
};

const compose = (str) => {
	return str.normalize('NFC');
};



const codePoints = (str) => {
	var code_points = Array.from(str)
		.map((v) =>{
			var hex = v.codePointAt(0).toString(16);
			return v + " = \\u{" + hex + "}";
		});
		
	console.log('codepoints for ',str,code_points);
}


var data = [
	{fieldx: 'ff-al'},
	{fieldx: 'ff-la'}
];
var sifter = new Sifter(data);

var result = sifter.search('-', {
	fields: ['fieldx']
});

assert.equal(result.items.length,2);



let str_composed	= 'أهلا'; // '\u{623}\u{647}\u{644}\u{627}'
let str_decomposed	= 'أهلا'; // '\u{627}\u{654}\u{647}\u{644}\u{627}'

//str_decomposed	= 'ﬄ';
//str_decomposed	= 'è';
str_composed = 'Ĳ';
str_decomposed = 'Ĳ'.normalize('NFKD');

	
sifter				= new Sifter([]);
//const composed		= 'a';
//const composed		= 'ŉ';
//const composed		= 'ffl';
const composed		= 'andrew';

//codePoints(composed.normalize('NFKD'));

tokens = sifter.tokenize(composed);
console.log(tokens);



//console.log('\u{623}\u{647}\u{644}\u{627}');
//console.log('\u{627}\u{654}\u{647}\u{644}\u{627}');
/*
codePoints(str_composed);
codePoints(asciifold(str_composed));
codePoints(compose(str_composed));

codePoints(str_decomposed);
codePoints(asciifold(str_decomposed));
codePoints(compose(str_decomposed));
*/


//console.log(str.length);
//console.log(str,asciifold(str));

//console.log(diacritics.generateDiacritics());


//reg = diacritics.diacriticRegexPoints('1 ae \u0041\u006d\u0065\u0301\u006c\u0069\u0065 ﬄ ffl Ĳ أهلا');

//console.log('reg length',reg);
//console.log('reg length',reg.length);

/*
reg = new RegExp('(?:(?:ae|Æ|Ǽ|Ǣ)|(?:A|Ⓐ|Ａ)|(?:E|ɛ|Ⓔ))');
reg = new RegExp('(?:(?:ae|Æ|Ǽ|Ǣ)|[AⒶＡ]|[AⒶＡ])');

str	= 'beaes'

pos = str.search(reg);

console.log('reg',reg);
console.log('pos',pos);

*/


//console.log('Ⱥ codepoints','Ⱥ'.codePointAt(0),'Ⱥ'.codePointAt(1));

//let latin		= toLatin('Ⱥ');
//console.log('Ⱥ latin',latin);

let string		= 'does this work? Ⱥ ?= \u023A \u023B \u023C A\u0335 A\u0338 A\u0337'
//console.log(string);
//console.log(toLatin(string));
